/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ClientRWLock
implements ReadWriteLock {
    private static final int MAX_AVAILABLE = 100;
    private final Semaphore mAvailable = new Semaphore(100, true);

    @Override
    public Lock readLock() {
        return new SessionLock(1);
    }

    @Override
    public Lock writeLock() {
        return new SessionLock(100);
    }

    private final class SessionLock
    implements Lock {
        private final int mPermits;

        private SessionLock(int permits) {
            this.mPermits = permits;
        }

        @Override
        public void lock() {
            ClientRWLock.this.mAvailable.acquireUninterruptibly(this.mPermits);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            ClientRWLock.this.mAvailable.acquire(this.mPermits);
        }

        @Override
        public boolean tryLock() {
            return ClientRWLock.this.mAvailable.tryAcquire(this.mPermits);
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            try {
                return ClientRWLock.this.mAvailable.tryAcquire(this.mPermits, time, unit);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @Override
        public void unlock() {
            ClientRWLock.this.mAvailable.release(this.mPermits);
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("newCondition() is not supported");
        }
    }
}

