/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.file.FileSystemMasterClient;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class PinListSync
implements HeartbeatExecutor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final BlockWorker mBlockWorker;
    private FileSystemMasterClient mMasterClient;

    public PinListSync(BlockWorker blockWorker, FileSystemMasterClient masterClient) {
        this.mBlockWorker = blockWorker;
        this.mMasterClient = masterClient;
    }

    public void heartbeat() {
        try {
            Set<Long> pinList = this.mMasterClient.getPinList();
            this.mBlockWorker.updatePinList(pinList);
        }
        catch (Exception e) {
            LOG.error("Failed to receive pinlist.", (Throwable)e);
        }
    }

    public void close() {
    }
}

