/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.util.CommonUtils;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockWorker;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class SessionCleaner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final BlockWorker mBlockWorker;
    private final int mCheckIntervalMs;
    private volatile boolean mRunning;

    public SessionCleaner(BlockWorker blockWorker) {
        this.mBlockWorker = blockWorker;
        this.mCheckIntervalMs = WorkerContext.getConf().getInt("alluxio.worker.block.heartbeat.interval.ms");
        this.mRunning = true;
    }

    @Override
    public void run() {
        long lastCheckMs = System.currentTimeMillis();
        while (this.mRunning) {
            long lastIntervalMs = System.currentTimeMillis() - lastCheckMs;
            long toSleepMs = (long)this.mCheckIntervalMs - lastIntervalMs;
            if (toSleepMs > 0L) {
                CommonUtils.sleepMs((Logger)LOG, (long)toSleepMs);
            } else {
                LOG.warn("Session cleanup took: {}, expected: {}", (Object)lastIntervalMs, (Object)this.mCheckIntervalMs);
            }
            lastCheckMs = System.currentTimeMillis();
            this.mBlockWorker.cleanupSessions();
        }
    }

    public void stop() {
        this.mRunning = false;
    }
}

