/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.StorageTierAssoc;
import alluxio.WorkerStorageTierAssoc;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.util.CommonUtils;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockWorker;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SpaceReserver
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final BlockWorker mBlockWorker;
    private final StorageTierAssoc mStorageTierAssoc;
    private final Map<String, Long> mBytesToReserveOnTiers = new HashMap<String, Long>();
    private final int mCheckIntervalMs;
    private volatile boolean mRunning;

    public SpaceReserver(BlockWorker blockWorker) {
        this.mBlockWorker = blockWorker;
        this.mStorageTierAssoc = new WorkerStorageTierAssoc(WorkerContext.getConf());
        Map<String, Long> capOnTiers = blockWorker.getStoreMeta().getCapacityBytesOnTiers();
        long lastTierReservedBytes = 0L;
        for (int ordinal = 0; ordinal < this.mStorageTierAssoc.size(); ++ordinal) {
            String tierReservedSpaceProp = String.format("alluxio.worker.tieredstore.level%d.reserved.ratio", ordinal);
            String tierAlias = this.mStorageTierAssoc.getAlias(ordinal);
            long reservedSpaceBytes = (long)((double)capOnTiers.get(tierAlias).longValue() * WorkerContext.getConf().getDouble(tierReservedSpaceProp));
            this.mBytesToReserveOnTiers.put(tierAlias, reservedSpaceBytes + lastTierReservedBytes);
            lastTierReservedBytes += reservedSpaceBytes;
        }
        this.mCheckIntervalMs = WorkerContext.getConf().getInt("alluxio.worker.tieredstore.reserver.interval.ms");
        this.mRunning = true;
    }

    @Override
    public void run() {
        long lastCheckMs = System.currentTimeMillis();
        while (this.mRunning) {
            long lastIntervalMs = System.currentTimeMillis() - lastCheckMs;
            long toSleepMs = (long)this.mCheckIntervalMs - lastIntervalMs;
            if (toSleepMs > 0L) {
                CommonUtils.sleepMs((Logger)LOG, (long)toSleepMs);
            } else {
                LOG.warn("Space reserver took: {}, expected: {}", (Object)lastIntervalMs, (Object)this.mCheckIntervalMs);
            }
            lastCheckMs = System.currentTimeMillis();
            this.reserveSpace();
        }
    }

    public void stop() {
        LOG.info("Space reserver exits!");
        this.mRunning = false;
    }

    private void reserveSpace() {
        for (int ordinal = this.mStorageTierAssoc.size() - 1; ordinal >= 0; --ordinal) {
            String tierAlias = this.mStorageTierAssoc.getAlias(ordinal);
            long bytesReserved = this.mBytesToReserveOnTiers.get(tierAlias);
            try {
                this.mBlockWorker.freeSpace(-3L, bytesReserved, tierAlias);
                continue;
            }
            catch (WorkerOutOfSpaceException e) {
                LOG.warn(e.getMessage());
                continue;
            }
            catch (BlockDoesNotExistException e) {
                LOG.warn(e.getMessage());
                continue;
            }
            catch (BlockAlreadyExistsException e) {
                LOG.warn(e.getMessage());
                continue;
            }
            catch (InvalidWorkerStateException e) {
                LOG.warn(e.getMessage());
                continue;
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
            }
        }
    }
}

