/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.Configuration;
import alluxio.StorageTierAssoc;
import alluxio.WorkerStorageTierAssoc;
import alluxio.collections.Pair;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.util.io.FileUtils;
import alluxio.util.io.PathUtils;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockLockManager;
import alluxio.worker.block.BlockLockType;
import alluxio.worker.block.BlockMetadataManager;
import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStore;
import alluxio.worker.block.BlockStoreEventListener;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.evictor.BlockTransferInfo;
import alluxio.worker.block.evictor.EvictionPlan;
import alluxio.worker.block.evictor.Evictor;
import alluxio.worker.block.io.BlockReader;
import alluxio.worker.block.io.BlockWriter;
import alluxio.worker.block.io.LocalFileBlockReader;
import alluxio.worker.block.io.LocalFileBlockWriter;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageDir;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTier;
import alluxio.worker.block.meta.TempBlockMeta;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class TieredBlockStore
implements BlockStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final int MAX_RETRIES = 3;
    private final Configuration mConfiguration;
    private final BlockMetadataManager mMetaManager;
    private final BlockLockManager mLockManager;
    private final Allocator mAllocator;
    private final Evictor mEvictor;
    private final List<BlockStoreEventListener> mBlockStoreEventListeners = new ArrayList<BlockStoreEventListener>();
    private final Set<Long> mPinnedInodes = new HashSet<Long>();
    private final ReentrantReadWriteLock mMetadataLock = new ReentrantReadWriteLock();
    private final Lock mMetadataReadLock = this.mMetadataLock.readLock();
    private final Lock mMetadataWriteLock = this.mMetadataLock.writeLock();
    private final StorageTierAssoc mStorageTierAssoc;

    public TieredBlockStore() {
        this.mConfiguration = WorkerContext.getConf();
        this.mMetaManager = BlockMetadataManager.createBlockMetadataManager();
        this.mLockManager = new BlockLockManager();
        BlockMetadataManagerView initManagerView = new BlockMetadataManagerView(this.mMetaManager, Collections.emptySet(), Collections.emptySet());
        this.mAllocator = Allocator.Factory.create(this.mConfiguration, initManagerView);
        if (this.mAllocator instanceof BlockStoreEventListener) {
            this.registerBlockStoreEventListener((BlockStoreEventListener)((Object)this.mAllocator));
        }
        initManagerView = new BlockMetadataManagerView(this.mMetaManager, Collections.emptySet(), Collections.emptySet());
        this.mEvictor = Evictor.Factory.create(this.mConfiguration, initManagerView, this.mAllocator);
        if (this.mEvictor instanceof BlockStoreEventListener) {
            this.registerBlockStoreEventListener((BlockStoreEventListener)((Object)this.mEvictor));
        }
        this.mStorageTierAssoc = new WorkerStorageTierAssoc(this.mConfiguration);
    }

    @Override
    public long lockBlock(long sessionId, long blockId) throws BlockDoesNotExistException {
        long lockId = this.mLockManager.lockBlock(sessionId, blockId, BlockLockType.READ);
        this.mMetadataReadLock.lock();
        boolean hasBlock = this.mMetaManager.hasBlockMeta(blockId);
        this.mMetadataReadLock.unlock();
        if (hasBlock) {
            return lockId;
        }
        this.mLockManager.unlockBlock(lockId);
        throw new BlockDoesNotExistException(ExceptionMessage.LOCK_RECORD_NOT_FOUND_FOR_BLOCK_AND_SESSION, new Object[]{blockId, sessionId});
    }

    @Override
    public void unlockBlock(long lockId) throws BlockDoesNotExistException {
        this.mLockManager.unlockBlock(lockId);
    }

    @Override
    public void unlockBlock(long sessionId, long blockId) throws BlockDoesNotExistException {
        this.mLockManager.unlockBlock(sessionId, blockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockWriter getBlockWriter(long sessionId, long blockId) throws BlockDoesNotExistException, IOException {
        this.mMetadataReadLock.lock();
        try {
            TempBlockMeta tempBlockMeta = this.mMetaManager.getTempBlockMeta(blockId);
            LocalFileBlockWriter localFileBlockWriter = new LocalFileBlockWriter(tempBlockMeta.getPath());
            return localFileBlockWriter;
        }
        finally {
            this.mMetadataReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockReader getBlockReader(long sessionId, long blockId, long lockId) throws BlockDoesNotExistException, InvalidWorkerStateException, IOException {
        this.mLockManager.validateLock(sessionId, blockId, lockId);
        this.mMetadataReadLock.lock();
        try {
            BlockMeta blockMeta = this.mMetaManager.getBlockMeta(blockId);
            LocalFileBlockReader localFileBlockReader = new LocalFileBlockReader(blockMeta.getPath());
            return localFileBlockReader;
        }
        finally {
            this.mMetadataReadLock.unlock();
        }
    }

    @Override
    public TempBlockMeta createBlockMeta(long sessionId, long blockId, BlockStoreLocation location, long initialBlockSize) throws BlockAlreadyExistsException, WorkerOutOfSpaceException, IOException {
        for (int i = 0; i < 4; ++i) {
            TempBlockMeta tempBlockMeta = this.createBlockMetaInternal(sessionId, blockId, location, initialBlockSize, true);
            if (tempBlockMeta != null) {
                return tempBlockMeta;
            }
            if (i >= 3) continue;
            this.freeSpaceInternal(sessionId, initialBlockSize, location);
        }
        throw new WorkerOutOfSpaceException(ExceptionMessage.NO_SPACE_FOR_BLOCK_ALLOCATION, new Object[]{initialBlockSize, 3, blockId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockMeta getVolatileBlockMeta(long blockId) throws BlockDoesNotExistException {
        this.mMetadataReadLock.lock();
        try {
            BlockMeta blockMeta = this.mMetaManager.getBlockMeta(blockId);
            return blockMeta;
        }
        finally {
            this.mMetadataReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockMeta getBlockMeta(long sessionId, long blockId, long lockId) throws BlockDoesNotExistException, InvalidWorkerStateException {
        this.mLockManager.validateLock(sessionId, blockId, lockId);
        this.mMetadataReadLock.lock();
        try {
            BlockMeta blockMeta = this.mMetaManager.getBlockMeta(blockId);
            return blockMeta;
        }
        finally {
            this.mMetadataReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitBlock(long sessionId, long blockId) throws BlockAlreadyExistsException, InvalidWorkerStateException, BlockDoesNotExistException, IOException {
        BlockStoreLocation loc = this.commitBlockInternal(sessionId, blockId);
        List<BlockStoreEventListener> list = this.mBlockStoreEventListeners;
        synchronized (list) {
            for (BlockStoreEventListener listener : this.mBlockStoreEventListeners) {
                listener.onCommitBlock(sessionId, blockId, loc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortBlock(long sessionId, long blockId) throws BlockAlreadyExistsException, BlockDoesNotExistException, InvalidWorkerStateException, IOException {
        this.abortBlockInternal(sessionId, blockId);
        List<BlockStoreEventListener> list = this.mBlockStoreEventListeners;
        synchronized (list) {
            for (BlockStoreEventListener listener : this.mBlockStoreEventListeners) {
                listener.onAbortBlock(sessionId, blockId);
            }
        }
    }

    @Override
    public void requestSpace(long sessionId, long blockId, long additionalBytes) throws BlockDoesNotExistException, WorkerOutOfSpaceException, IOException {
        for (int i = 0; i < 4; ++i) {
            Pair<Boolean, BlockStoreLocation> requestResult = this.requestSpaceInternal(blockId, additionalBytes);
            if (((Boolean)requestResult.getFirst()).booleanValue()) {
                return;
            }
            if (i >= 3) continue;
            this.freeSpaceInternal(sessionId, additionalBytes, (BlockStoreLocation)requestResult.getSecond());
        }
        throw new WorkerOutOfSpaceException(ExceptionMessage.NO_SPACE_FOR_BLOCK_ALLOCATION, new Object[]{additionalBytes, 3, blockId});
    }

    @Override
    public void moveBlock(long sessionId, long blockId, BlockStoreLocation newLocation) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, WorkerOutOfSpaceException, IOException {
        this.moveBlock(sessionId, blockId, BlockStoreLocation.anyTier(), newLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveBlock(long sessionId, long blockId, BlockStoreLocation oldLocation, BlockStoreLocation newLocation) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, WorkerOutOfSpaceException, IOException {
        for (int i = 0; i < 4; ++i) {
            MoveBlockResult moveResult = this.moveBlockInternal(sessionId, blockId, oldLocation, newLocation);
            if (moveResult.getSuccess()) {
                List<BlockStoreEventListener> list = this.mBlockStoreEventListeners;
                synchronized (list) {
                    for (BlockStoreEventListener listener : this.mBlockStoreEventListeners) {
                        listener.onMoveBlockByClient(sessionId, blockId, moveResult.getSrcLocation(), moveResult.getDstLocation());
                    }
                }
                return;
            }
            if (i >= 3) continue;
            this.freeSpaceInternal(sessionId, moveResult.getBlockSize(), newLocation);
        }
        throw new WorkerOutOfSpaceException(ExceptionMessage.NO_SPACE_FOR_BLOCK_MOVE, new Object[]{newLocation, blockId, 3});
    }

    @Override
    public void removeBlock(long sessionId, long blockId) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException {
        this.removeBlock(sessionId, blockId, BlockStoreLocation.anyTier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlock(long sessionId, long blockId, BlockStoreLocation location) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException {
        this.removeBlockInternal(sessionId, blockId, location);
        List<BlockStoreEventListener> list = this.mBlockStoreEventListeners;
        synchronized (list) {
            for (BlockStoreEventListener listener : this.mBlockStoreEventListeners) {
                listener.onRemoveBlockByClient(sessionId, blockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accessBlock(long sessionId, long blockId) throws BlockDoesNotExistException {
        this.mMetadataReadLock.lock();
        boolean hasBlock = this.mMetaManager.hasBlockMeta(blockId);
        this.mMetadataReadLock.unlock();
        if (!hasBlock) {
            throw new BlockDoesNotExistException(ExceptionMessage.NO_BLOCK_ID_FOUND, new Object[]{blockId});
        }
        List<BlockStoreEventListener> list = this.mBlockStoreEventListeners;
        synchronized (list) {
            for (BlockStoreEventListener listener : this.mBlockStoreEventListeners) {
                listener.onAccessBlock(sessionId, blockId);
            }
        }
    }

    @Override
    public void freeSpace(long sessionId, long availableBytes, BlockStoreLocation location) throws BlockDoesNotExistException, WorkerOutOfSpaceException, IOException {
        this.freeSpaceInternal(sessionId, availableBytes, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupSession(long sessionId) {
        List<TempBlockMeta> tempBlocksToRemove;
        this.mLockManager.cleanupSession(sessionId);
        this.mMetadataReadLock.lock();
        try {
            tempBlocksToRemove = this.mMetaManager.getSessionTempBlocks(sessionId);
        }
        finally {
            this.mMetadataReadLock.unlock();
        }
        for (TempBlockMeta tempBlockMeta : tempBlocksToRemove) {
            try {
                this.abortBlockInternal(sessionId, tempBlockMeta.getBlockId());
            }
            catch (Exception e) {
                LOG.error("Failed to cleanup tempBlock {} due to {}", (Object)tempBlockMeta.getBlockId(), (Object)e.getMessage());
            }
        }
        for (StorageTier tier : this.mMetaManager.getTiers()) {
            for (StorageDir dir : tier.getStorageDirs()) {
                String sessionFolderPath = PathUtils.concatPath((Object)dir.getDirPath(), (Object[])new Object[]{sessionId});
                try {
                    if (!new File(sessionFolderPath).exists()) continue;
                    FileUtils.delete((String)sessionFolderPath);
                }
                catch (IOException e) {
                    LOG.error("Failed to clean up session: {} with directory: {}", (Object)sessionId, (Object)sessionFolderPath);
                }
            }
        }
    }

    @Override
    public boolean hasBlockMeta(long blockId) {
        this.mMetadataReadLock.lock();
        boolean hasBlock = this.mMetaManager.hasBlockMeta(blockId);
        this.mMetadataReadLock.unlock();
        return hasBlock;
    }

    @Override
    public BlockStoreMeta getBlockStoreMeta() {
        this.mMetadataReadLock.lock();
        BlockStoreMeta storeMeta = this.mMetaManager.getBlockStoreMeta();
        this.mMetadataReadLock.unlock();
        return storeMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBlockStoreEventListener(BlockStoreEventListener listener) {
        List<BlockStoreEventListener> list = this.mBlockStoreEventListeners;
        synchronized (list) {
            this.mBlockStoreEventListeners.add(listener);
        }
    }

    private void checkTempBlockIdAvailable(long blockId) throws BlockAlreadyExistsException {
        if (this.mMetaManager.hasTempBlockMeta(blockId)) {
            throw new BlockAlreadyExistsException(ExceptionMessage.TEMP_BLOCK_ID_EXISTS, new Object[]{blockId});
        }
        if (this.mMetaManager.hasBlockMeta(blockId)) {
            throw new BlockAlreadyExistsException(ExceptionMessage.TEMP_BLOCK_ID_COMMITTED, new Object[]{blockId});
        }
    }

    private void checkTempBlockOwnedBySession(long sessionId, long blockId) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException {
        if (this.mMetaManager.hasBlockMeta(blockId)) {
            throw new BlockAlreadyExistsException(ExceptionMessage.TEMP_BLOCK_ID_COMMITTED, new Object[]{blockId});
        }
        TempBlockMeta tempBlockMeta = this.mMetaManager.getTempBlockMeta(blockId);
        long ownerSessionId = tempBlockMeta.getSessionId();
        if (ownerSessionId != sessionId) {
            throw new InvalidWorkerStateException(ExceptionMessage.BLOCK_ID_FOR_DIFFERENT_SESSION, new Object[]{blockId, ownerSessionId, sessionId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortBlockInternal(long sessionId, long blockId) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, IOException {
        long lockId = this.mLockManager.lockBlock(sessionId, blockId, BlockLockType.WRITE);
        try {
            String path;
            TempBlockMeta tempBlockMeta;
            this.mMetadataReadLock.lock();
            try {
                this.checkTempBlockOwnedBySession(sessionId, blockId);
                tempBlockMeta = this.mMetaManager.getTempBlockMeta(blockId);
                path = tempBlockMeta.getPath();
            }
            finally {
                this.mMetadataReadLock.unlock();
            }
            FileUtils.delete((String)path);
            this.mMetadataWriteLock.lock();
            try {
                this.mMetaManager.abortTempBlockMeta(tempBlockMeta);
            }
            catch (BlockDoesNotExistException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.mMetadataWriteLock.unlock();
            }
        }
        finally {
            this.mLockManager.unlockBlock(lockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockStoreLocation commitBlockInternal(long sessionId, long blockId) throws BlockAlreadyExistsException, InvalidWorkerStateException, BlockDoesNotExistException, IOException {
        long lockId = this.mLockManager.lockBlock(sessionId, blockId, BlockLockType.WRITE);
        try {
            BlockStoreLocation loc;
            String dstPath;
            String srcPath;
            TempBlockMeta tempBlockMeta;
            this.mMetadataReadLock.lock();
            try {
                this.checkTempBlockOwnedBySession(sessionId, blockId);
                tempBlockMeta = this.mMetaManager.getTempBlockMeta(blockId);
                srcPath = tempBlockMeta.getPath();
                dstPath = tempBlockMeta.getCommitPath();
                loc = tempBlockMeta.getBlockLocation();
            }
            finally {
                this.mMetadataReadLock.unlock();
            }
            FileUtils.move((String)srcPath, (String)dstPath);
            this.mMetadataWriteLock.lock();
            try {
                this.mMetaManager.commitTempBlockMeta(tempBlockMeta);
            }
            catch (BlockAlreadyExistsException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (BlockDoesNotExistException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (WorkerOutOfSpaceException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.mMetadataWriteLock.unlock();
            }
            BlockStoreLocation blockStoreLocation = loc;
            return blockStoreLocation;
        }
        finally {
            this.mLockManager.unlockBlock(lockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TempBlockMeta createBlockMetaInternal(long sessionId, long blockId, BlockStoreLocation location, long initialBlockSize, boolean newBlock) throws BlockAlreadyExistsException {
        this.mMetadataWriteLock.lock();
        try {
            StorageDirView dirView;
            if (newBlock) {
                this.checkTempBlockIdAvailable(blockId);
            }
            if ((dirView = this.mAllocator.allocateBlockWithView(sessionId, initialBlockSize, location, this.getUpdatedView())) == null) {
                TempBlockMeta tempBlockMeta = null;
                return tempBlockMeta;
            }
            TempBlockMeta tempBlock = dirView.createTempBlockMeta(sessionId, blockId, initialBlockSize);
            try {
                this.mMetaManager.addTempBlockMeta(tempBlock);
            }
            catch (WorkerOutOfSpaceException e) {
                LOG.error("Unexpected failure: {} bytes allocated at {} by allocator, but addTempBlockMeta failed", (Object)initialBlockSize, (Object)location);
                throw Throwables.propagate((Throwable)e);
            }
            catch (BlockAlreadyExistsException e) {
                LOG.error("Unexpected failure: {} bytes allocated at {} by allocator, but addTempBlockMeta failed", (Object)initialBlockSize, (Object)location);
                throw Throwables.propagate((Throwable)e);
            }
            TempBlockMeta tempBlockMeta = tempBlock;
            return tempBlockMeta;
        }
        finally {
            this.mMetadataWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Boolean, BlockStoreLocation> requestSpaceInternal(long blockId, long additionalBytes) throws BlockDoesNotExistException {
        this.mMetadataWriteLock.lock();
        try {
            TempBlockMeta tempBlockMeta = this.mMetaManager.getTempBlockMeta(blockId);
            if (tempBlockMeta.getParentDir().getAvailableBytes() < additionalBytes) {
                Pair pair = new Pair((Object)false, (Object)tempBlockMeta.getBlockLocation());
                return pair;
            }
            try {
                this.mMetaManager.resizeTempBlockMeta(tempBlockMeta, tempBlockMeta.getBlockSize() + additionalBytes);
            }
            catch (InvalidWorkerStateException e) {
                throw Throwables.propagate((Throwable)e);
            }
            Pair pair = new Pair((Object)true, null);
            return pair;
        }
        finally {
            this.mMetadataWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSpaceInternal(long sessionId, long availableBytes, BlockStoreLocation location) throws WorkerOutOfSpaceException, IOException {
        EvictionPlan plan;
        this.mMetadataReadLock.lock();
        try {
            plan = this.mEvictor.freeSpaceWithView(availableBytes, location, this.getUpdatedView());
            if (plan == null) {
                throw new WorkerOutOfSpaceException(ExceptionMessage.NO_EVICTION_PLAN_TO_FREE_SPACE, new Object[0]);
            }
        }
        finally {
            this.mMetadataReadLock.unlock();
        }
        for (Pair<Long, BlockStoreLocation> blockInfo : plan.toEvict()) {
            try {
                this.removeBlockInternal(sessionId, (Long)blockInfo.getFirst(), (BlockStoreLocation)blockInfo.getSecond());
            }
            catch (InvalidWorkerStateException e) {
                LOG.error("Failed to evict blockId {}, this is temp block", blockInfo.getFirst());
                continue;
            }
            catch (BlockDoesNotExistException e) {
                LOG.info("Failed to evict blockId {}, it could be already deleted", blockInfo.getFirst());
                continue;
            }
            List<BlockStoreEventListener> e = this.mBlockStoreEventListeners;
            synchronized (e) {
                for (BlockStoreEventListener listener : this.mBlockStoreEventListeners) {
                    listener.onRemoveBlockByWorker(sessionId, (Long)blockInfo.getFirst());
                }
            }
        }
        HashMap blocksGroupedByDestTier = new HashMap();
        for (BlockTransferInfo entry : plan.toMove()) {
            String alias = entry.getDstLocation().tierAlias();
            if (!blocksGroupedByDestTier.containsKey(alias)) {
                blocksGroupedByDestTier.put(alias, new HashSet());
            }
            ((Set)blocksGroupedByDestTier.get(alias)).add(entry);
        }
        for (int tierOrdinal = this.mStorageTierAssoc.size() - 1; tierOrdinal >= 0; --tierOrdinal) {
            HashSet toMove = (HashSet)blocksGroupedByDestTier.get(this.mStorageTierAssoc.getAlias(tierOrdinal));
            if (toMove == null) {
                toMove = new HashSet();
            }
            for (BlockTransferInfo entry : toMove) {
                MoveBlockResult moveResult;
                long blockId = entry.getBlockId();
                BlockStoreLocation oldLocation = entry.getSrcLocation();
                BlockStoreLocation newLocation = entry.getDstLocation();
                try {
                    moveResult = this.moveBlockInternal(sessionId, blockId, oldLocation, newLocation);
                }
                catch (InvalidWorkerStateException e) {
                    LOG.error("Failed to evict blockId {}, this is temp block", (Object)blockId);
                    continue;
                }
                catch (BlockAlreadyExistsException e) {
                    continue;
                }
                catch (BlockDoesNotExistException e) {
                    LOG.info("Failed to move blockId {}, it could be already deleted", (Object)blockId);
                    continue;
                }
                if (!moveResult.getSuccess()) continue;
                List<BlockStoreEventListener> list = this.mBlockStoreEventListeners;
                synchronized (list) {
                    for (BlockStoreEventListener listener : this.mBlockStoreEventListeners) {
                        listener.onMoveBlockByWorker(sessionId, blockId, moveResult.getSrcLocation(), newLocation);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockMetadataManagerView getUpdatedView() {
        Set<Long> set = this.mPinnedInodes;
        synchronized (set) {
            return new BlockMetadataManagerView(this.mMetaManager, this.mPinnedInodes, this.mLockManager.getLockedBlocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoveBlockResult moveBlockInternal(long sessionId, long blockId, BlockStoreLocation oldLocation, BlockStoreLocation newLocation) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, IOException {
        long lockId = this.mLockManager.lockBlock(sessionId, blockId, BlockLockType.WRITE);
        try {
            long blockSize;
            String srcFilePath;
            BlockStoreLocation srcLocation;
            BlockMeta srcBlockMeta;
            this.mMetadataReadLock.lock();
            try {
                if (this.mMetaManager.hasTempBlockMeta(blockId)) {
                    throw new InvalidWorkerStateException(ExceptionMessage.MOVE_UNCOMMITTED_BLOCK, new Object[]{blockId});
                }
                srcBlockMeta = this.mMetaManager.getBlockMeta(blockId);
                srcLocation = srcBlockMeta.getBlockLocation();
                srcFilePath = srcBlockMeta.getPath();
                blockSize = srcBlockMeta.getBlockSize();
            }
            finally {
                this.mMetadataReadLock.unlock();
            }
            if (!srcLocation.belongsTo(oldLocation)) {
                throw new BlockDoesNotExistException(ExceptionMessage.BLOCK_NOT_FOUND_AT_LOCATION, new Object[]{blockId, oldLocation});
            }
            TempBlockMeta dstTempBlock = this.createBlockMetaInternal(sessionId, blockId, newLocation, blockSize, false);
            if (dstTempBlock == null) {
                MoveBlockResult moveBlockResult = new MoveBlockResult(false, blockSize, null, null);
                return moveBlockResult;
            }
            BlockStoreLocation dstLocation = dstTempBlock.getBlockLocation();
            if (dstLocation.belongsTo(srcLocation)) {
                this.mMetaManager.abortTempBlockMeta(dstTempBlock);
                MoveBlockResult moveBlockResult = new MoveBlockResult(true, blockSize, srcLocation, dstLocation);
                return moveBlockResult;
            }
            String dstFilePath = dstTempBlock.getCommitPath();
            FileUtils.move((String)srcFilePath, (String)dstFilePath);
            this.mMetadataWriteLock.lock();
            try {
                this.mMetaManager.moveBlockMeta(srcBlockMeta, dstTempBlock);
            }
            catch (BlockAlreadyExistsException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (BlockDoesNotExistException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (WorkerOutOfSpaceException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.mMetadataWriteLock.unlock();
            }
            MoveBlockResult moveBlockResult = new MoveBlockResult(true, blockSize, srcLocation, dstLocation);
            return moveBlockResult;
        }
        finally {
            this.mLockManager.unlockBlock(lockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBlockInternal(long sessionId, long blockId, BlockStoreLocation location) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException {
        long lockId = this.mLockManager.lockBlock(sessionId, blockId, BlockLockType.WRITE);
        try {
            String filePath;
            BlockMeta blockMeta;
            this.mMetadataReadLock.lock();
            try {
                if (this.mMetaManager.hasTempBlockMeta(blockId)) {
                    throw new InvalidWorkerStateException(ExceptionMessage.REMOVE_UNCOMMITTED_BLOCK, new Object[]{blockId});
                }
                blockMeta = this.mMetaManager.getBlockMeta(blockId);
                filePath = blockMeta.getPath();
            }
            finally {
                this.mMetadataReadLock.unlock();
            }
            if (!blockMeta.getBlockLocation().belongsTo(location)) {
                throw new BlockDoesNotExistException(ExceptionMessage.BLOCK_NOT_FOUND_AT_LOCATION, new Object[]{blockId, location});
            }
            FileUtils.delete((String)filePath);
            this.mMetadataWriteLock.lock();
            try {
                this.mMetaManager.removeBlockMeta(blockMeta);
            }
            catch (BlockDoesNotExistException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.mMetadataWriteLock.unlock();
            }
        }
        finally {
            this.mLockManager.unlockBlock(lockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePinnedInodes(Set<Long> inodes) {
        Set<Long> set = this.mPinnedInodes;
        synchronized (set) {
            this.mPinnedInodes.clear();
            this.mPinnedInodes.addAll((Collection)Preconditions.checkNotNull(inodes));
        }
    }

    private static class MoveBlockResult {
        private final boolean mSuccess;
        private final long mBlockSize;
        private final BlockStoreLocation mSrcLocation;
        private final BlockStoreLocation mDstLocation;

        MoveBlockResult(boolean success, long blockSize, BlockStoreLocation srcLocation, BlockStoreLocation dstLocation) {
            this.mSuccess = success;
            this.mBlockSize = blockSize;
            this.mSrcLocation = srcLocation;
            this.mDstLocation = dstLocation;
        }

        boolean getSuccess() {
            return this.mSuccess;
        }

        long getBlockSize() {
            return this.mBlockSize;
        }

        BlockStoreLocation getSrcLocation() {
            return this.mSrcLocation;
        }

        BlockStoreLocation getDstLocation() {
            return this.mDstLocation;
        }
    }
}

