/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.allocator;

import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTierView;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GreedyAllocator
implements Allocator {
    private BlockMetadataManagerView mManagerView;

    public GreedyAllocator(BlockMetadataManagerView view) {
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)view);
    }

    @Override
    public StorageDirView allocateBlockWithView(long sessionId, long blockSize, BlockStoreLocation location, BlockMetadataManagerView view) {
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)view);
        return this.allocateBlock(sessionId, blockSize, location);
    }

    private StorageDirView allocateBlock(long sessionId, long blockSize, BlockStoreLocation location) {
        Preconditions.checkNotNull((Object)location);
        if (location.equals(BlockStoreLocation.anyTier())) {
            for (StorageTierView tierView : this.mManagerView.getTierViews()) {
                for (StorageDirView dirView : tierView.getDirViews()) {
                    if (dirView.getAvailableBytes() < blockSize) continue;
                    return dirView;
                }
            }
            return null;
        }
        String tierAlias = location.tierAlias();
        StorageTierView tierView = this.mManagerView.getTierView(tierAlias);
        if (location.equals(BlockStoreLocation.anyDirInTier(tierAlias))) {
            for (StorageDirView dirView : tierView.getDirViews()) {
                if (dirView.getAvailableBytes() < blockSize) continue;
                return dirView;
            }
            return null;
        }
        int dirIndex = location.dir();
        StorageDirView dirView = tierView.getDirView(dirIndex);
        if (dirView.getAvailableBytes() >= blockSize) {
            return dirView;
        }
        return null;
    }
}

