/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.allocator;

import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTierView;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MaxFreeAllocator
implements Allocator {
    private BlockMetadataManagerView mManagerView;

    public MaxFreeAllocator(BlockMetadataManagerView view) {
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)view);
    }

    @Override
    public StorageDirView allocateBlockWithView(long sessionId, long blockSize, BlockStoreLocation location, BlockMetadataManagerView view) {
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)view);
        return this.allocateBlock(sessionId, blockSize, location);
    }

    private StorageDirView allocateBlock(long sessionId, long blockSize, BlockStoreLocation location) {
        Preconditions.checkNotNull((Object)location);
        StorageDirView candidateDirView = null;
        if (location.equals(BlockStoreLocation.anyTier())) {
            StorageTierView tierView;
            Iterator<StorageTierView> i$ = this.mManagerView.getTierViews().iterator();
            while (i$.hasNext() && (candidateDirView = this.getCandidateDirInTier(tierView = i$.next(), blockSize)) == null) {
            }
        } else if (location.equals(BlockStoreLocation.anyDirInTier(location.tierAlias()))) {
            StorageTierView tierView = this.mManagerView.getTierView(location.tierAlias());
            candidateDirView = this.getCandidateDirInTier(tierView, blockSize);
        } else {
            StorageTierView tierView = this.mManagerView.getTierView(location.tierAlias());
            StorageDirView dirView = tierView.getDirView(location.dir());
            if (dirView.getAvailableBytes() >= blockSize) {
                candidateDirView = dirView;
            }
        }
        return candidateDirView;
    }

    private StorageDirView getCandidateDirInTier(StorageTierView tierView, long blockSize) {
        StorageDirView candidateDirView = null;
        long maxFreeBytes = blockSize - 1L;
        for (StorageDirView dirView : tierView.getDirViews()) {
            if (dirView.getAvailableBytes() <= maxFreeBytes) continue;
            maxFreeBytes = dirView.getAvailableBytes();
            candidateDirView = dirView;
        }
        return candidateDirView;
    }
}

