/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.allocator;

import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTierView;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class RoundRobinAllocator
implements Allocator {
    private BlockMetadataManagerView mManagerView;
    private Map<String, Integer> mTierAliasToLastDirMap = Maps.newHashMap();

    public RoundRobinAllocator(BlockMetadataManagerView view) {
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)view);
        for (StorageTierView tierView : this.mManagerView.getTierViews()) {
            this.mTierAliasToLastDirMap.put(tierView.getTierViewAlias(), -1);
        }
    }

    @Override
    public StorageDirView allocateBlockWithView(long sessionId, long blockSize, BlockStoreLocation location, BlockMetadataManagerView view) {
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)view);
        return this.allocateBlock(sessionId, blockSize, location);
    }

    private StorageDirView allocateBlock(long sessionId, long blockSize, BlockStoreLocation location) {
        Preconditions.checkNotNull((Object)location);
        if (location.equals(BlockStoreLocation.anyTier())) {
            int tierIndex = 0;
            for (int i = 0; i < this.mManagerView.getTierViews().size(); ++i) {
                StorageTierView tierView = this.mManagerView.getTierViews().get(tierIndex);
                int dirViewIndex = this.getNextAvailDirInTier(tierView, blockSize);
                if (dirViewIndex >= 0) {
                    this.mTierAliasToLastDirMap.put(tierView.getTierViewAlias(), dirViewIndex);
                    return tierView.getDirView(dirViewIndex);
                }
                ++tierIndex;
            }
        } else if (location.equals(BlockStoreLocation.anyDirInTier(location.tierAlias()))) {
            StorageTierView tierView = this.mManagerView.getTierView(location.tierAlias());
            int dirViewIndex = this.getNextAvailDirInTier(tierView, blockSize);
            if (dirViewIndex >= 0) {
                this.mTierAliasToLastDirMap.put(tierView.getTierViewAlias(), dirViewIndex);
                return tierView.getDirView(dirViewIndex);
            }
        } else {
            StorageTierView tierView = this.mManagerView.getTierView(location.tierAlias());
            StorageDirView dirView = tierView.getDirView(location.dir());
            if (dirView.getAvailableBytes() >= blockSize) {
                return dirView;
            }
        }
        return null;
    }

    private int getNextAvailDirInTier(StorageTierView tierView, long blockSize) {
        int dirViewIndex = this.mTierAliasToLastDirMap.get(tierView.getTierViewAlias());
        for (int i = 0; i < tierView.getDirViews().size(); ++i) {
            if (tierView.getDirView(dirViewIndex = (dirViewIndex + 1) % tierView.getDirViews().size()).getAvailableBytes() < blockSize) continue;
            return dirViewIndex;
        }
        return -1;
    }
}

