/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.evictor;

import alluxio.collections.Pair;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.worker.block.AbstractBlockStoreEventListener;
import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.evictor.BlockTransferInfo;
import alluxio.worker.block.evictor.EvictionDirCandidates;
import alluxio.worker.block.evictor.EvictionPlan;
import alluxio.worker.block.evictor.Evictor;
import alluxio.worker.block.evictor.EvictorUtils;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTierView;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractEvictor
extends AbstractBlockStoreEventListener
implements Evictor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    protected final Allocator mAllocator;
    protected BlockMetadataManagerView mManagerView;

    public AbstractEvictor(BlockMetadataManagerView view, Allocator allocator) {
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)view);
        this.mAllocator = (Allocator)Preconditions.checkNotNull((Object)allocator);
    }

    protected StorageDirView cascadingEvict(long bytesToBeAvailable, BlockStoreLocation location, EvictionPlan plan) {
        StorageDirView candidateDirView = EvictorUtils.selectDirWithRequestedSpace(bytesToBeAvailable, location = this.updateBlockStoreLocation(bytesToBeAvailable, location), this.mManagerView);
        if (candidateDirView != null) {
            return candidateDirView;
        }
        EvictionDirCandidates dirCandidates = new EvictionDirCandidates();
        Iterator<Long> it = this.getBlockIterator();
        while (it.hasNext() && dirCandidates.candidateSize() < bytesToBeAvailable) {
            long blockId = it.next();
            try {
                BlockMeta block = this.mManagerView.getBlockMeta(blockId);
                if (block == null || !block.getBlockLocation().belongsTo(location)) continue;
                String tierAlias = block.getParentDir().getParentTier().getTierAlias();
                int dirIndex = block.getParentDir().getDirIndex();
                dirCandidates.add(this.mManagerView.getTierView(tierAlias).getDirView(dirIndex), blockId, block.getBlockSize());
            }
            catch (BlockDoesNotExistException e) {
                LOG.warn("Remove block {} from evictor cache because {}", (Object)blockId, (Object)e);
                it.remove();
                this.onRemoveBlockFromIterator(blockId);
            }
        }
        if (dirCandidates.candidateSize() < bytesToBeAvailable) {
            return null;
        }
        candidateDirView = dirCandidates.candidateDir();
        List<Long> candidateBlocks = dirCandidates.candidateBlocks();
        StorageTierView nextTierView = this.mManagerView.getNextTier(candidateDirView.getParentTierView());
        if (nextTierView == null) {
            for (Long blockId : candidateBlocks) {
                try {
                    BlockMeta block = this.mManagerView.getBlockMeta(blockId);
                    if (block == null) continue;
                    candidateDirView.markBlockMoveOut(blockId, block.getBlockSize());
                    plan.toEvict().add((Pair<Long, BlockStoreLocation>)new Pair((Object)blockId, (Object)candidateDirView.toBlockStoreLocation()));
                }
                catch (BlockDoesNotExistException e) {}
            }
        } else {
            for (Long blockId : candidateBlocks) {
                try {
                    BlockMeta block = this.mManagerView.getBlockMeta(blockId);
                    if (block == null) continue;
                    StorageDirView nextDirView = this.mAllocator.allocateBlockWithView(-3L, block.getBlockSize(), BlockStoreLocation.anyDirInTier(nextTierView.getTierViewAlias()), this.mManagerView);
                    if (nextDirView == null) {
                        nextDirView = this.cascadingEvict(block.getBlockSize(), BlockStoreLocation.anyDirInTier(nextTierView.getTierViewAlias()), plan);
                    }
                    if (nextDirView == null) {
                        plan.toEvict().add((Pair<Long, BlockStoreLocation>)new Pair((Object)blockId, (Object)block.getBlockLocation()));
                        candidateDirView.markBlockMoveOut(blockId, block.getBlockSize());
                        continue;
                    }
                    plan.toMove().add(new BlockTransferInfo(blockId, block.getBlockLocation(), nextDirView.toBlockStoreLocation()));
                    candidateDirView.markBlockMoveOut(blockId, block.getBlockSize());
                    nextDirView.markBlockMoveIn(blockId, block.getBlockSize());
                }
                catch (BlockDoesNotExistException e) {}
            }
        }
        return candidateDirView;
    }

    @Override
    public EvictionPlan freeSpaceWithView(long bytesToBeAvailable, BlockStoreLocation location, BlockMetadataManagerView view) {
        this.mManagerView = view;
        ArrayList<BlockTransferInfo> toMove = new ArrayList<BlockTransferInfo>();
        ArrayList<Pair<Long, BlockStoreLocation>> toEvict = new ArrayList<Pair<Long, BlockStoreLocation>>();
        EvictionPlan plan = new EvictionPlan(toMove, toEvict);
        StorageDirView candidateDir = this.cascadingEvict(bytesToBeAvailable, location, plan);
        this.mManagerView.clearBlockMarks();
        if (candidateDir == null) {
            return null;
        }
        return plan;
    }

    protected abstract Iterator<Long> getBlockIterator();

    protected void onRemoveBlockFromIterator(long blockId) {
    }

    protected BlockStoreLocation updateBlockStoreLocation(long bytesToBeAvailable, BlockStoreLocation location) {
        return location;
    }
}

