/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.evictor;

import alluxio.collections.Pair;
import alluxio.worker.block.meta.StorageDirView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class EvictionDirCandidates {
    private Map<StorageDirView, Pair<List<Long>, Long>> mDirCandidates = new HashMap<StorageDirView, Pair<List<Long>, Long>>();
    private long mMaxBytes = 0L;
    private StorageDirView mDirWithMaxBytes = null;

    EvictionDirCandidates() {
    }

    public void add(StorageDirView dir, long blockId, long blockSizeBytes) {
        Pair candidate;
        if (this.mDirCandidates.containsKey(dir)) {
            candidate = this.mDirCandidates.get(dir);
        } else {
            candidate = new Pair(new ArrayList(), (Object)0L);
            this.mDirCandidates.put(dir, (Pair<List<Long>, Long>)candidate);
        }
        ((List)candidate.getFirst()).add(blockId);
        long blockBytes = (Long)candidate.getSecond() + blockSizeBytes;
        candidate.setSecond((Object)blockBytes);
        long sum = blockBytes + dir.getAvailableBytes();
        if (this.mMaxBytes < sum) {
            this.mMaxBytes = sum;
            this.mDirWithMaxBytes = dir;
        }
    }

    public long candidateSize() {
        return this.mMaxBytes;
    }

    public List<Long> candidateBlocks() {
        Pair<List<Long>, Long> evict = this.mDirCandidates.get(this.mDirWithMaxBytes);
        if (evict == null) {
            return new ArrayList<Long>();
        }
        return (List)evict.getFirst();
    }

    public StorageDirView candidateDir() {
        return this.mDirWithMaxBytes;
    }
}

