/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.evictor;

import alluxio.collections.Pair;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.evictor.BlockTransferInfo;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class EvictionPlan {
    private final List<BlockTransferInfo> mToMove;
    private final List<Pair<Long, BlockStoreLocation>> mToEvict;

    public EvictionPlan(List<BlockTransferInfo> toTransfer, List<Pair<Long, BlockStoreLocation>> toEvict) {
        this.mToMove = (List)Preconditions.checkNotNull(toTransfer);
        this.mToEvict = (List)Preconditions.checkNotNull(toEvict);
    }

    public List<BlockTransferInfo> toMove() {
        return this.mToMove;
    }

    public List<Pair<Long, BlockStoreLocation>> toEvict() {
        return this.mToEvict;
    }

    public boolean isEmpty() {
        return this.mToEvict.isEmpty() && this.mToMove.isEmpty();
    }

    public String toString() {
        return "toMove: " + this.mToMove.toString() + ", toEvict: " + this.mToEvict.toString();
    }
}

