/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.evictor;

import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTierView;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class EvictorUtils {
    public static StorageDirView getDirWithMaxFreeSpace(long bytesToBeAvailable, BlockStoreLocation location, BlockMetadataManagerView mManagerView) {
        long maxFreeSize = -1L;
        StorageDirView selectedDirView = null;
        if (location.equals(BlockStoreLocation.anyTier())) {
            for (StorageTierView tierView : mManagerView.getTierViews()) {
                for (StorageDirView dirView : tierView.getDirViews()) {
                    if (dirView.getCommittedBytes() + dirView.getAvailableBytes() < bytesToBeAvailable || dirView.getAvailableBytes() <= maxFreeSize) continue;
                    selectedDirView = dirView;
                    maxFreeSize = dirView.getAvailableBytes();
                }
            }
        } else {
            String tierAlias = location.tierAlias();
            StorageTierView tierView = mManagerView.getTierView(tierAlias);
            if (location.equals(BlockStoreLocation.anyDirInTier(tierAlias))) {
                for (StorageDirView dirView : tierView.getDirViews()) {
                    if (dirView.getCommittedBytes() + dirView.getAvailableBytes() < bytesToBeAvailable || dirView.getAvailableBytes() <= maxFreeSize) continue;
                    selectedDirView = dirView;
                    maxFreeSize = dirView.getAvailableBytes();
                }
            } else {
                int dirIndex = location.dir();
                StorageDirView dirView = tierView.getDirView(dirIndex);
                if (dirView.getCommittedBytes() + dirView.getAvailableBytes() >= bytesToBeAvailable && dirView.getAvailableBytes() > maxFreeSize) {
                    selectedDirView = dirView;
                    maxFreeSize = dirView.getAvailableBytes();
                }
            }
        }
        return selectedDirView;
    }

    public static StorageDirView selectDirWithRequestedSpace(long bytesToBeAvailable, BlockStoreLocation location, BlockMetadataManagerView mManagerView) {
        if (location.equals(BlockStoreLocation.anyTier())) {
            for (StorageTierView tierView : mManagerView.getTierViews()) {
                for (StorageDirView dirView : tierView.getDirViews()) {
                    if (dirView.getAvailableBytes() < bytesToBeAvailable) continue;
                    return dirView;
                }
            }
            return null;
        }
        String tierAlias = location.tierAlias();
        StorageTierView tierView = mManagerView.getTierView(tierAlias);
        if (location.equals(BlockStoreLocation.anyDirInTier(tierAlias))) {
            for (StorageDirView dirView : tierView.getDirViews()) {
                if (dirView.getAvailableBytes() < bytesToBeAvailable) continue;
                return dirView;
            }
            return null;
        }
        StorageDirView dirView = tierView.getDirView(location.dir());
        return dirView.getAvailableBytes() >= bytesToBeAvailable ? dirView : null;
    }

    private EvictorUtils() {
    }
}

