/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.evictor;

import alluxio.collections.Pair;
import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.evictor.BlockTransferInfo;
import alluxio.worker.block.evictor.EvictionPlan;
import alluxio.worker.block.evictor.Evictor;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTierView;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GreedyEvictor
implements Evictor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public GreedyEvictor(BlockMetadataManagerView view, Allocator allocator) {
    }

    @Override
    public EvictionPlan freeSpaceWithView(long availableBytes, BlockStoreLocation location, BlockMetadataManagerView view) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)view);
        StorageDirView selectedDirView = null;
        if (location.equals(BlockStoreLocation.anyTier())) {
            selectedDirView = this.selectEvictableDirFromAnyTier(view, availableBytes);
        } else {
            String tierAlias = location.tierAlias();
            StorageTierView tierView = view.getTierView(tierAlias);
            if (location.equals(BlockStoreLocation.anyDirInTier(tierAlias))) {
                selectedDirView = this.selectEvictableDirFromTier(tierView, availableBytes);
            } else {
                int dirIndex = location.dir();
                StorageDirView dir = tierView.getDirView(dirIndex);
                if (this.canEvictBlocksFromDir(dir, availableBytes)) {
                    selectedDirView = dir;
                }
            }
        }
        if (selectedDirView == null) {
            LOG.error("Failed to freeSpace: No StorageDirView has enough capacity of {} bytes", (Object)availableBytes);
            return null;
        }
        ArrayList<BlockTransferInfo> toTransfer = new ArrayList<BlockTransferInfo>();
        ArrayList<Pair<Long, BlockStoreLocation>> toEvict = new ArrayList<Pair<Long, BlockStoreLocation>>();
        long bytesAvailableInDir = selectedDirView.getAvailableBytes();
        if (bytesAvailableInDir >= availableBytes) {
            return new EvictionPlan(toTransfer, toEvict);
        }
        ArrayList<BlockMeta> victimBlocks = new ArrayList<BlockMeta>();
        for (BlockMeta block : selectedDirView.getEvictableBlocks()) {
            victimBlocks.add(block);
            if ((bytesAvailableInDir += block.getBlockSize()) < availableBytes) continue;
            break;
        }
        HashMap<StorageDirView, Long> pendingBytesInDir = new HashMap<StorageDirView, Long>();
        for (BlockMeta block : victimBlocks) {
            String fromTierAlias;
            List<StorageTierView> candidateTiers;
            StorageDirView dstDir = this.selectAvailableDir(block, candidateTiers = view.getTierViewsBelow(fromTierAlias = block.getParentDir().getParentTier().getTierAlias()), pendingBytesInDir);
            if (dstDir == null) {
                toEvict.add((Pair<Long, BlockStoreLocation>)new Pair((Object)block.getBlockId(), (Object)block.getBlockLocation()));
                continue;
            }
            StorageTierView dstTier = dstDir.getParentTierView();
            toTransfer.add(new BlockTransferInfo(block.getBlockId(), block.getBlockLocation(), new BlockStoreLocation(dstTier.getTierViewAlias(), dstDir.getDirViewIndex())));
            if (pendingBytesInDir.containsKey(dstDir)) {
                pendingBytesInDir.put(dstDir, (Long)pendingBytesInDir.get(dstDir) + block.getBlockSize());
                continue;
            }
            pendingBytesInDir.put(dstDir, block.getBlockSize());
        }
        return new EvictionPlan(toTransfer, toEvict);
    }

    private boolean canEvictBlocksFromDir(StorageDirView dirView, long bytesToBeAvailable) {
        return dirView.getAvailableBytes() + dirView.getEvitableBytes() >= bytesToBeAvailable;
    }

    private StorageDirView selectEvictableDirFromAnyTier(BlockMetadataManagerView view, long availableBytes) {
        for (StorageTierView tierView : view.getTierViews()) {
            for (StorageDirView dirView : tierView.getDirViews()) {
                if (!this.canEvictBlocksFromDir(dirView, availableBytes)) continue;
                return dirView;
            }
        }
        return null;
    }

    private StorageDirView selectEvictableDirFromTier(StorageTierView tierView, long availableBytes) {
        for (StorageDirView dirView : tierView.getDirViews()) {
            if (!this.canEvictBlocksFromDir(dirView, availableBytes)) continue;
            return dirView;
        }
        return null;
    }

    private StorageDirView selectAvailableDir(BlockMeta block, List<StorageTierView> candidateTiers, Map<StorageDirView, Long> pendingBytesInDir) {
        for (StorageTierView candidateTier : candidateTiers) {
            for (StorageDirView candidateDir : candidateTier.getDirViews()) {
                long pendingBytes = 0L;
                if (pendingBytesInDir.containsKey(candidateDir)) {
                    pendingBytes = pendingBytesInDir.get(candidateDir);
                }
                if (candidateDir.getAvailableBytes() - pendingBytes < block.getBlockSize()) continue;
                return candidateDir;
            }
        }
        return null;
    }
}

