/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.evictor;

import alluxio.Configuration;
import alluxio.collections.Pair;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.evictor.AbstractEvictor;
import alluxio.worker.block.evictor.BlockTransferInfo;
import alluxio.worker.block.evictor.EvictionPlan;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTierView;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LRFUEvictor
extends AbstractEvictor {
    private final Map<Long, Long> mBlockIdToLastUpdateTime = new ConcurrentHashMap<Long, Long>();
    private final Map<Long, Double> mBlockIdToCRFValue = new ConcurrentHashMap<Long, Double>();
    private final double mStepFactor;
    private final double mAttenuationFactor;
    private final Configuration mConfiguration;
    private AtomicLong mLogicTimeCount = new AtomicLong(0L);

    public LRFUEvictor(BlockMetadataManagerView view, Allocator allocator) {
        super(view, allocator);
        this.mConfiguration = WorkerContext.getConf();
        this.mStepFactor = this.mConfiguration.getDouble("alluxio.worker.evictor.lrfu.step.factor");
        this.mAttenuationFactor = this.mConfiguration.getDouble("alluxio.worker.evictor.lrfu.attenuation.factor");
        Preconditions.checkArgument((this.mStepFactor >= 0.0 && this.mStepFactor <= 1.0 ? 1 : 0) != 0, (Object)"Step factor should be in the range of [0.0, 1.0]");
        Preconditions.checkArgument((this.mAttenuationFactor >= 2.0 ? 1 : 0) != 0, (Object)"Attenuation factor should be no less than 2.0");
        for (StorageTierView tier : this.mManagerView.getTierViews()) {
            for (StorageDirView dir : tier.getDirViews()) {
                for (BlockMeta block : dir.getEvictableBlocks()) {
                    this.mBlockIdToLastUpdateTime.put(block.getBlockId(), 0L);
                    this.mBlockIdToCRFValue.put(block.getBlockId(), 0.0);
                }
            }
        }
    }

    private double calculateAccessWeight(long logicTimeInterval) {
        return Math.pow(1.0 / this.mAttenuationFactor, (double)logicTimeInterval * this.mStepFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvictionPlan freeSpaceWithView(long bytesToBeAvailable, BlockStoreLocation location, BlockMetadataManagerView view) {
        Map<Long, Long> map = this.mBlockIdToLastUpdateTime;
        synchronized (map) {
            this.updateCRFValue();
            this.mManagerView = view;
            ArrayList<BlockTransferInfo> toMove = new ArrayList<BlockTransferInfo>();
            ArrayList<Pair<Long, BlockStoreLocation>> toEvict = new ArrayList<Pair<Long, BlockStoreLocation>>();
            EvictionPlan plan = new EvictionPlan(toMove, toEvict);
            StorageDirView candidateDir = this.cascadingEvict(bytesToBeAvailable, location, plan);
            this.mManagerView.clearBlockMarks();
            if (candidateDir == null) {
                return null;
            }
            return plan;
        }
    }

    @Override
    protected Iterator<Long> getBlockIterator() {
        return Iterators.transform(this.getSortedCRF().iterator(), (Function)new Function<Map.Entry<Long, Double>, Long>(){

            public Long apply(Map.Entry<Long, Double> input) {
                return input.getKey();
            }
        });
    }

    private List<Map.Entry<Long, Double>> getSortedCRF() {
        ArrayList<Map.Entry<Long, Double>> sortedCRF = new ArrayList<Map.Entry<Long, Double>>(this.mBlockIdToCRFValue.entrySet());
        Collections.sort(sortedCRF, new Comparator<Map.Entry<Long, Double>>(){

            @Override
            public int compare(Map.Entry<Long, Double> o1, Map.Entry<Long, Double> o2) {
                return Double.compare(o1.getValue(), o2.getValue());
            }
        });
        return sortedCRF;
    }

    @Override
    public void onAccessBlock(long userId, long blockId) {
        this.updateOnAccessAndCommit(blockId);
    }

    @Override
    public void onCommitBlock(long userId, long blockId, BlockStoreLocation location) {
        this.updateOnAccessAndCommit(blockId);
    }

    @Override
    public void onRemoveBlockByClient(long userId, long blockId) {
        this.updateOnRemoveBlock(blockId);
    }

    @Override
    public void onRemoveBlockByWorker(long userId, long blockId) {
        this.updateOnRemoveBlock(blockId);
    }

    @Override
    protected void onRemoveBlockFromIterator(long blockId) {
        this.mBlockIdToLastUpdateTime.remove(blockId);
        this.mBlockIdToCRFValue.remove(blockId);
    }

    private void updateCRFValue() {
        long currentLogicTime = this.mLogicTimeCount.get();
        for (Map.Entry<Long, Double> entry : this.mBlockIdToCRFValue.entrySet()) {
            long blockId = entry.getKey();
            double crfValue = entry.getValue();
            this.mBlockIdToCRFValue.put(blockId, crfValue * this.calculateAccessWeight(currentLogicTime - this.mBlockIdToLastUpdateTime.get(blockId)));
            this.mBlockIdToLastUpdateTime.put(blockId, currentLogicTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnAccessAndCommit(long blockId) {
        Map<Long, Long> map = this.mBlockIdToLastUpdateTime;
        synchronized (map) {
            long currentLogicTime = this.mLogicTimeCount.incrementAndGet();
            if (this.mBlockIdToCRFValue.containsKey(blockId)) {
                this.mBlockIdToCRFValue.put(blockId, this.mBlockIdToCRFValue.get(blockId) * this.calculateAccessWeight(currentLogicTime - this.mBlockIdToLastUpdateTime.get(blockId)) + 1.0);
            } else {
                this.mBlockIdToCRFValue.put(blockId, 1.0);
            }
            this.mBlockIdToLastUpdateTime.put(blockId, currentLogicTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnRemoveBlock(long blockId) {
        Map<Long, Long> map = this.mBlockIdToLastUpdateTime;
        synchronized (map) {
            this.mLogicTimeCount.incrementAndGet();
            this.mBlockIdToCRFValue.remove(blockId);
            this.mBlockIdToLastUpdateTime.remove(blockId);
        }
    }
}

