/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.evictor;

import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.evictor.AbstractEvictor;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTierView;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LRUEvictor
extends AbstractEvictor {
    private static final int LINKED_HASH_MAP_INIT_CAPACITY = 200;
    private static final float LINKED_HASH_MAP_INIT_LOAD_FACTOR = 0.75f;
    private static final boolean LINKED_HASH_MAP_ACCESS_ORDERED = true;
    private static final boolean UNUSED_MAP_VALUE = true;
    protected Map<Long, Boolean> mLRUCache = Collections.synchronizedMap(new LinkedHashMap(200, 0.75f, true));

    public LRUEvictor(BlockMetadataManagerView view, Allocator allocator) {
        super(view, allocator);
        for (StorageTierView tierView : this.mManagerView.getTierViews()) {
            for (StorageDirView dirView : tierView.getDirViews()) {
                for (BlockMeta blockMeta : dirView.getEvictableBlocks()) {
                    this.mLRUCache.put(blockMeta.getBlockId(), true);
                }
            }
        }
    }

    @Override
    protected Iterator<Long> getBlockIterator() {
        ArrayList blocks = Lists.newArrayList(this.mLRUCache.keySet());
        return blocks.iterator();
    }

    @Override
    public void onAccessBlock(long sessionId, long blockId) {
        this.mLRUCache.put(blockId, true);
    }

    @Override
    public void onCommitBlock(long sessionId, long blockId, BlockStoreLocation location) {
        this.mLRUCache.put(blockId, true);
    }

    @Override
    public void onRemoveBlockByClient(long sessionId, long blockId) {
        this.mLRUCache.remove(blockId);
    }

    @Override
    public void onRemoveBlockByWorker(long sessionId, long blockId) {
        this.mLRUCache.remove(blockId);
    }

    @Override
    protected void onRemoveBlockFromIterator(long blockId) {
        this.mLRUCache.remove(blockId);
    }
}

