/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.evictor;

import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.allocator.Allocator;
import alluxio.worker.block.evictor.EvictorUtils;
import alluxio.worker.block.evictor.LRUEvictor;
import alluxio.worker.block.meta.StorageDirView;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PartialLRUEvictor
extends LRUEvictor {
    public PartialLRUEvictor(BlockMetadataManagerView view, Allocator allocator) {
        super(view, allocator);
    }

    @Override
    protected BlockStoreLocation updateBlockStoreLocation(long bytesToBeAvailable, BlockStoreLocation location) {
        StorageDirView candidateDirView = EvictorUtils.getDirWithMaxFreeSpace(bytesToBeAvailable, location, this.mManagerView);
        if (candidateDirView != null) {
            return new BlockStoreLocation(location.tierAlias(), candidateDirView.getDirViewIndex());
        }
        return location;
    }
}

