/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.meta;

import alluxio.util.io.PathUtils;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.meta.StorageDir;
import alluxio.worker.block.meta.StorageTier;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractBlockMeta {
    protected final long mBlockId;
    protected final StorageDir mDir;

    public static String tempPath(StorageDir dir, long sessionId, long blockId) {
        return PathUtils.concatPath((Object)dir.getDirPath(), (Object[])new Object[]{sessionId, blockId});
    }

    public static String commitPath(StorageDir dir, long blockId) {
        return PathUtils.concatPath((Object)dir.getDirPath(), (Object[])new Object[]{blockId});
    }

    public AbstractBlockMeta(long blockId, StorageDir dir) {
        this.mBlockId = blockId;
        this.mDir = (StorageDir)Preconditions.checkNotNull((Object)dir);
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public BlockStoreLocation getBlockLocation() {
        StorageTier tier = this.mDir.getParentTier();
        return new BlockStoreLocation(tier.getTierAlias(), this.mDir.getDirIndex());
    }

    public StorageDir getParentDir() {
        return this.mDir;
    }

    public abstract String getPath();

    public abstract long getBlockSize();
}

