/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.meta;

import alluxio.worker.block.meta.AbstractBlockMeta;
import alluxio.worker.block.meta.StorageDir;
import alluxio.worker.block.meta.TempBlockMeta;
import java.io.File;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BlockMeta
extends AbstractBlockMeta {
    private final long mBlockSize;

    public BlockMeta(long blockId, long blockSize, StorageDir dir) {
        super(blockId, dir);
        this.mBlockSize = blockSize;
    }

    public BlockMeta(TempBlockMeta tempBlock) {
        super(tempBlock.getBlockId(), tempBlock.getParentDir());
        this.mBlockSize = new File(tempBlock.getCommitPath()).length();
    }

    @Override
    public long getBlockSize() {
        return this.mBlockSize;
    }

    @Override
    public String getPath() {
        return BlockMeta.commitPath(this.mDir, this.mBlockId);
    }
}

