/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.meta;

import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageDir;
import alluxio.worker.block.meta.StorageTierView;
import alluxio.worker.block.meta.TempBlockMeta;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class StorageDirView {
    private final StorageDir mDir;
    private final StorageTierView mTierView;
    private final BlockMetadataManagerView mManagerView;
    private final Set<Long> mBlocksToMoveIn = new HashSet<Long>();
    private final Set<Long> mBlocksToMoveOut = new HashSet<Long>();
    private long mBlocksToMoveInSize = 0L;
    private long mBlocksToMoveOutSize = 0L;

    public StorageDirView(StorageDir dir, StorageTierView tierView, BlockMetadataManagerView managerView) {
        this.mDir = (StorageDir)Preconditions.checkNotNull((Object)dir);
        this.mTierView = (StorageTierView)Preconditions.checkNotNull((Object)tierView);
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)managerView);
    }

    public int getDirViewIndex() {
        return this.mDir.getDirIndex();
    }

    public List<BlockMeta> getEvictableBlocks() {
        ArrayList<BlockMeta> filteredList = new ArrayList<BlockMeta>();
        for (BlockMeta blockMeta : this.mDir.getBlocks()) {
            long blockId = blockMeta.getBlockId();
            if (!this.mManagerView.isBlockEvictable(blockId)) continue;
            filteredList.add(blockMeta);
        }
        return filteredList;
    }

    public long getCapacityBytes() {
        return this.mDir.getCapacityBytes();
    }

    public long getAvailableBytes() {
        return this.mDir.getAvailableBytes() + this.mBlocksToMoveOutSize - this.mBlocksToMoveInSize;
    }

    public long getCommittedBytes() {
        return this.mDir.getCommittedBytes();
    }

    public long getEvitableBytes() {
        long bytes = 0L;
        for (BlockMeta blockMeta : this.mDir.getBlocks()) {
            long blockId = blockMeta.getBlockId();
            if (!this.mManagerView.isBlockEvictable(blockId)) continue;
            bytes += blockMeta.getBlockSize();
        }
        return bytes;
    }

    public void clearBlockMarks() {
        this.mBlocksToMoveIn.clear();
        this.mBlocksToMoveOut.clear();
        this.mBlocksToMoveOutSize = 0L;
        this.mBlocksToMoveInSize = 0L;
    }

    public TempBlockMeta createTempBlockMeta(long sessionId, long blockId, long initialBlockSize) {
        return new TempBlockMeta(sessionId, blockId, initialBlockSize, this.mDir);
    }

    public StorageTierView getParentTierView() {
        return this.mTierView;
    }

    public boolean isMarkedToMoveOut(long blockId) {
        return this.mBlocksToMoveOut.contains(blockId);
    }

    public void markBlockMoveIn(long blockId, long blockSize) {
        if (this.mBlocksToMoveIn.add(blockId)) {
            this.mBlocksToMoveInSize += blockSize;
        }
    }

    public void markBlockMoveOut(long blockId, long blockSize) {
        if (this.mBlocksToMoveOut.add(blockId)) {
            this.mBlocksToMoveOutSize += blockSize;
        }
    }

    public BlockStoreLocation toBlockStoreLocation() {
        return this.mDir.toBlockStoreLocation();
    }
}

