/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.meta;

import alluxio.WorkerStorageTierAssoc;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.util.FormatUtils;
import alluxio.util.io.PathUtils;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.meta.StorageDir;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class StorageTier {
    private final String mTierAlias;
    private final int mTierOrdinal;
    private long mCapacityBytes;
    private List<StorageDir> mDirs;

    private StorageTier(String tierAlias) {
        this.mTierAlias = tierAlias;
        this.mTierOrdinal = new WorkerStorageTierAssoc(WorkerContext.getConf()).getOrdinal(tierAlias);
    }

    private void initStorageTier() throws BlockAlreadyExistsException, IOException, WorkerOutOfSpaceException {
        String workerDataFolder = WorkerContext.getConf().get("alluxio.worker.data.folder");
        String tierDirPathConf = String.format("alluxio.worker.tieredstore.level%d.dirs.path", this.mTierOrdinal);
        String[] dirPaths = WorkerContext.getConf().get(tierDirPathConf).split(",");
        for (int i = 0; i < dirPaths.length; ++i) {
            dirPaths[i] = PathUtils.concatPath((Object)dirPaths[i].trim(), (Object[])new Object[]{workerDataFolder});
        }
        String tierDirCapacityConf = String.format("alluxio.worker.tieredstore.level%d.dirs.quota", this.mTierOrdinal);
        String[] dirQuotas = WorkerContext.getConf().get(tierDirCapacityConf).split(",");
        this.mDirs = new ArrayList<StorageDir>(dirPaths.length);
        long totalCapacity = 0L;
        for (int i = 0; i < dirPaths.length; ++i) {
            int index = i >= dirQuotas.length ? dirQuotas.length - 1 : i;
            long capacity = FormatUtils.parseSpaceSize((String)dirQuotas[index]);
            totalCapacity += capacity;
            this.mDirs.add(StorageDir.newStorageDir(this, i, capacity, dirPaths[i]));
        }
        this.mCapacityBytes = totalCapacity;
    }

    public static StorageTier newStorageTier(String tierAlias) throws BlockAlreadyExistsException, IOException, WorkerOutOfSpaceException {
        StorageTier ret = new StorageTier(tierAlias);
        ret.initStorageTier();
        return ret;
    }

    public int getTierOrdinal() {
        return this.mTierOrdinal;
    }

    public String getTierAlias() {
        return this.mTierAlias;
    }

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public long getAvailableBytes() {
        long availableBytes = 0L;
        for (StorageDir dir : this.mDirs) {
            availableBytes += dir.getAvailableBytes();
        }
        return availableBytes;
    }

    public StorageDir getDir(int dirIndex) {
        return this.mDirs.get(dirIndex);
    }

    public List<StorageDir> getStorageDirs() {
        return Collections.unmodifiableList(this.mDirs);
    }
}

