/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.meta;

import alluxio.worker.block.BlockMetadataManagerView;
import alluxio.worker.block.meta.StorageDir;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTier;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StorageTierView {
    private final StorageTier mTier;
    private final List<StorageDirView> mDirViews = new ArrayList<StorageDirView>();
    private final BlockMetadataManagerView mManagerView;

    public StorageTierView(StorageTier tier, BlockMetadataManagerView view) {
        this.mTier = (StorageTier)Preconditions.checkNotNull((Object)tier);
        this.mManagerView = (BlockMetadataManagerView)Preconditions.checkNotNull((Object)view);
        for (StorageDir dir : this.mTier.getStorageDirs()) {
            StorageDirView dirView = new StorageDirView(dir, this, view);
            this.mDirViews.add(dirView);
        }
    }

    public List<StorageDirView> getDirViews() {
        return Collections.unmodifiableList(this.mDirViews);
    }

    public StorageDirView getDirView(int dirIndex) {
        return this.mDirViews.get(dirIndex);
    }

    public String getTierViewAlias() {
        return this.mTier.getTierAlias();
    }

    public int getTierViewOrdinal() {
        return this.mTier.getTierOrdinal();
    }

    public BlockMetadataManagerView getBlockMetadataManagerView() {
        return this.mManagerView;
    }
}

