/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.meta;

import alluxio.worker.block.meta.AbstractBlockMeta;
import alluxio.worker.block.meta.StorageDir;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class TempBlockMeta
extends AbstractBlockMeta {
    private final long mSessionId;
    private long mTempBlockSize;

    public TempBlockMeta(long sessionId, long blockId, long initialBlockSize, StorageDir dir) {
        super(blockId, dir);
        this.mSessionId = sessionId;
        this.mTempBlockSize = initialBlockSize;
    }

    @Override
    public long getBlockSize() {
        return this.mTempBlockSize;
    }

    @Override
    public String getPath() {
        return TempBlockMeta.tempPath(this.mDir, this.mSessionId, this.mBlockId);
    }

    public String getCommitPath() {
        return TempBlockMeta.commitPath(this.mDir, this.mBlockId);
    }

    public long getSessionId() {
        return this.mSessionId;
    }

    public void setBlockSize(long newSize) {
        this.mTempBlockSize = newSize;
    }
}

