/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.file;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileInfo;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.block.io.BlockReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class FileDataManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final UnderFileSystem mUfs;
    private final BlockWorker mBlockWorker;
    @GuardedBy(value="mLock")
    private final Map<Long, Map<Long, Long>> mPersistingInProgressFiles;
    @GuardedBy(value="mLock")
    private final Set<Long> mPersistedFiles;
    private final Configuration mConfiguration;
    private final Object mLock = new Object();

    public FileDataManager(BlockWorker blockWorker) {
        this.mBlockWorker = (BlockWorker)Preconditions.checkNotNull((Object)blockWorker);
        this.mPersistingInProgressFiles = Maps.newHashMap();
        this.mPersistedFiles = Sets.newHashSet();
        this.mConfiguration = WorkerContext.getConf();
        String ufsAddress = this.mConfiguration.get("alluxio.underfs.address");
        this.mUfs = UnderFileSystem.get((String)ufsAddress, (Configuration)this.mConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFilePersisting(long fileId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPersistedFiles.contains(fileId);
        }
    }

    public boolean needPersistence(long fileId) {
        if (this.isFilePersisting(fileId) || this.isFilePersisted(fileId)) {
            return false;
        }
        try {
            if (this.fileExistsInUfs(fileId)) {
                this.addPersistedFile(fileId);
                return false;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to check if file {} exists in under storage system", (Object)fileId, (Object)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFilePersisted(long fileId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPersistedFiles.contains(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPersistedFile(long fileId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistedFiles.add(fileId);
        }
    }

    private synchronized boolean fileExistsInUfs(long fileId) throws IOException {
        String ufsRoot = this.mConfiguration.get("alluxio.underfs.address");
        FileInfo fileInfo = this.mBlockWorker.getFileInfo(fileId);
        String dstPath = PathUtils.concatPath((Object)ufsRoot, (Object[])new Object[]{fileInfo.getPath()});
        return this.mUfs.exists(dstPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockBlocks(long fileId, List<Long> blockIds) throws IOException {
        HashMap blockIdToLockId = Maps.newHashMap();
        ArrayList<BlockDoesNotExistException> errors = new ArrayList<BlockDoesNotExistException>();
        Object object = this.mLock;
        synchronized (object) {
            block11: {
                if (this.mPersistingInProgressFiles.containsKey(fileId)) {
                    throw new IOException("the file " + fileId + " is already being persisted");
                }
                try {
                    for (long blockId : blockIds) {
                        long l = this.mBlockWorker.lockBlock(-2L, blockId);
                        blockIdToLockId.put(blockId, l);
                    }
                }
                catch (BlockDoesNotExistException e) {
                    errors.add(e);
                    Iterator i$ = blockIdToLockId.values().iterator();
                    while (i$.hasNext()) {
                        long lockId = (Long)i$.next();
                        try {
                            this.mBlockWorker.unlockBlock(lockId);
                        }
                        catch (BlockDoesNotExistException bdnee) {
                            errors.add(bdnee);
                        }
                    }
                    if (errors.isEmpty()) break block11;
                    StringBuilder errorStr = new StringBuilder();
                    errorStr.append("failed to lock all blocks of file ").append(fileId).append("\n");
                    for (Throwable throwable : errors) {
                        errorStr.append(throwable).append('\n');
                    }
                    throw new IOException(errorStr.toString());
                }
            }
            this.mPersistingInProgressFiles.put(fileId, blockIdToLockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFile(long fileId, List<Long> blockIds) throws IOException {
        WritableByteChannel outputChannel;
        OutputStream outputStream;
        block25: {
            Map<Long, Long> blockIdToLockId;
            Object object = this.mLock;
            synchronized (object) {
                blockIdToLockId = this.mPersistingInProgressFiles.get(fileId);
                if (blockIdToLockId == null || !blockIdToLockId.keySet().equals(Sets.newHashSet(blockIds))) {
                    throw new IOException("Not all the blocks of file " + fileId + " are blocked");
                }
            }
            String dstPath = this.prepareUfsFilePath(fileId);
            outputStream = this.mUfs.create(dstPath);
            outputChannel = Channels.newChannel(outputStream);
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            try {
                for (long blockId : blockIds) {
                    long lockId = blockIdToLockId.get(blockId);
                    BlockReader reader = this.mBlockWorker.readBlockRemote(-2L, blockId, lockId);
                    ReadableByteChannel inputChannel = reader.getChannel();
                    BufferUtils.fastCopy((ReadableByteChannel)inputChannel, (WritableByteChannel)outputChannel);
                    reader.close();
                }
            }
            catch (BlockDoesNotExistException e) {
                errors.add(e);
            }
            catch (InvalidWorkerStateException e) {
                errors.add(e);
            }
            finally {
                for (long lockId : blockIdToLockId.values()) {
                    try {
                        this.mBlockWorker.unlockBlock(lockId);
                    }
                    catch (BlockDoesNotExistException e) {
                        errors.add(e);
                    }
                }
                if (errors.isEmpty()) break block25;
                StringBuilder errorStr = new StringBuilder();
                errorStr.append("the blocks of file").append(fileId).append(" are failed to persist\n");
                for (Throwable e : errors) {
                    errorStr.append(e).append('\n');
                }
                throw new IOException(errorStr.toString());
            }
        }
        outputStream.flush();
        outputChannel.close();
        outputStream.close();
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistingInProgressFiles.remove(fileId);
            this.mPersistedFiles.add(fileId);
        }
    }

    private String prepareUfsFilePath(long fileId) throws IOException {
        String ufsRoot = this.mConfiguration.get("alluxio.underfs.address");
        FileInfo fileInfo = this.mBlockWorker.getFileInfo(fileId);
        AlluxioURI uri = new AlluxioURI(fileInfo.getPath());
        String dstPath = PathUtils.concatPath((Object)ufsRoot, (Object[])new Object[]{fileInfo.getPath()});
        LOG.info("persist file {} at {}", (Object)fileId, (Object)dstPath);
        String parentPath = PathUtils.concatPath((Object)ufsRoot, (Object[])new Object[]{uri.getParent().getPath()});
        if (!this.mUfs.exists(parentPath) && !this.mUfs.mkdirs(parentPath, true)) {
            throw new IOException("Failed to create " + parentPath);
        }
        return dstPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getPersistedFiles() {
        ArrayList toReturn = Lists.newArrayList();
        Object object = this.mLock;
        synchronized (object) {
            toReturn.addAll(this.mPersistedFiles);
            return toReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPersistedFiles(List<Long> persistedFiles) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistedFiles.removeAll(persistedFiles);
        }
    }
}

