/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.file;

import alluxio.AbstractClient;
import alluxio.AbstractMasterClient;
import alluxio.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.thrift.AlluxioService;
import alluxio.thrift.FileInfo;
import alluxio.thrift.FileSystemCommand;
import alluxio.thrift.FileSystemMasterWorkerService;
import alluxio.wire.ThriftUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileSystemMasterClient
extends AbstractMasterClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private FileSystemMasterWorkerService.Client mClient = null;

    public FileSystemMasterClient(InetSocketAddress masterAddress, Configuration configuration) {
        super(masterAddress, configuration);
    }

    protected AlluxioService.Client getClient() {
        return this.mClient;
    }

    protected String getServiceName() {
        return "FileSystemMasterWorker";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() throws IOException {
        this.mClient = new FileSystemMasterWorkerService.Client(this.mProtocol);
    }

    public synchronized alluxio.wire.FileInfo getFileInfo(final long fileId) throws AlluxioException, IOException {
        return (alluxio.wire.FileInfo)this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<alluxio.wire.FileInfo>(){

            public alluxio.wire.FileInfo call() throws TException {
                return ThriftUtils.fromThrift((FileInfo)FileSystemMasterClient.this.mClient.getFileInfo(fileId));
            }
        });
    }

    public synchronized Set<Long> getPinList() throws ConnectionFailedException, IOException {
        return (Set)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Set<Long>>(){

            public Set<Long> call() throws TException {
                return FileSystemMasterClient.this.mClient.getPinIdList();
            }
        });
    }

    public synchronized FileSystemCommand heartbeat(final long workerId, final List<Long> persistedFiles) throws ConnectionFailedException, IOException {
        return (FileSystemCommand)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<FileSystemCommand>(){

            public FileSystemCommand call() throws TException {
                return FileSystemMasterClient.this.mClient.heartbeat(workerId, persistedFiles);
            }
        });
    }
}

