/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.file;

import alluxio.Configuration;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.util.ThreadFactoryUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.AbstractWorker;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.file.FileDataManager;
import alluxio.worker.file.FileSystemMasterClient;
import alluxio.worker.file.FileWorkerMasterSyncExecutor;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TProcessor;

@NotThreadSafe
public final class FileSystemWorker
extends AbstractWorker {
    private final FileDataManager mFileDataManager;
    private final FileSystemMasterClient mFileSystemMasterWorkerClient;
    private final Configuration mConf = WorkerContext.getConf();
    private Future<?> mFilePersistenceService;

    public FileSystemWorker(BlockWorker blockWorker) throws IOException {
        super(Executors.newFixedThreadPool(3, ThreadFactoryUtils.build((String)"file-system-worker-heartbeat-%d", (boolean)true)));
        this.mFileDataManager = new FileDataManager((BlockWorker)Preconditions.checkNotNull((Object)blockWorker));
        this.mFileSystemMasterWorkerClient = new FileSystemMasterClient(NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (Configuration)this.mConf), this.mConf);
    }

    @Override
    public Map<String, TProcessor> getServices() {
        return new HashMap<String, TProcessor>();
    }

    @Override
    public void start() {
        this.mFilePersistenceService = this.getExecutorService().submit((Runnable)new HeartbeatThread("Worker FileSystemMaster Sync", (HeartbeatExecutor)new FileWorkerMasterSyncExecutor(this.mFileDataManager, this.mFileSystemMasterWorkerClient), (long)this.mConf.getInt("alluxio.worker.filesystem.heartbeat.interval.ms")));
    }

    @Override
    public void stop() {
        if (this.mFilePersistenceService != null) {
            this.mFilePersistenceService.cancel(true);
        }
        this.mFileSystemMasterWorkerClient.close();
        this.getExecutorService().shutdown();
    }
}

