/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.file;

import alluxio.exception.ConnectionFailedException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.thrift.CommandType;
import alluxio.thrift.FileSystemCommand;
import alluxio.thrift.PersistFile;
import alluxio.util.ThreadFactoryUtils;
import alluxio.worker.WorkerContext;
import alluxio.worker.WorkerIdRegistry;
import alluxio.worker.file.FileDataManager;
import alluxio.worker.file.FileSystemMasterClient;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class FileWorkerMasterSyncExecutor
implements HeartbeatExecutor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final FileDataManager mFileDataManager;
    private final FileSystemMasterClient mMasterClient;
    private final ExecutorService mPersistFileService;

    public FileWorkerMasterSyncExecutor(FileDataManager fileDataManager, FileSystemMasterClient masterClient) {
        this.mFileDataManager = (FileDataManager)Preconditions.checkNotNull((Object)fileDataManager);
        this.mMasterClient = (FileSystemMasterClient)((Object)Preconditions.checkNotNull((Object)((Object)masterClient)));
        this.mPersistFileService = Executors.newFixedThreadPool(WorkerContext.getConf().getInt("alluxio.worker.file.persist.pool.size"), ThreadFactoryUtils.build((String)"persist-file-service-%d", (boolean)true));
    }

    public void heartbeat() {
        List<Long> persistedFiles = this.mFileDataManager.getPersistedFiles();
        if (!persistedFiles.isEmpty()) {
            LOG.info("files {} persisted", persistedFiles);
        }
        FileSystemCommand command = null;
        try {
            command = this.mMasterClient.heartbeat(WorkerIdRegistry.getWorkerId(), persistedFiles);
        }
        catch (IOException e) {
            LOG.error("Failed to heartbeat to master", (Throwable)e);
            return;
        }
        catch (ConnectionFailedException e) {
            LOG.error("Failed to heartbeat to master", (Throwable)e);
            return;
        }
        this.mFileDataManager.clearPersistedFiles(persistedFiles);
        if (command == null) {
            LOG.error("The command sent from master is null");
            return;
        }
        if (command.getCommandType() != CommandType.Persist) {
            LOG.error("The command sent from master should be PERSIST type, but was {}", (Object)command.getCommandType());
            return;
        }
        for (PersistFile persistFile : command.getCommandOptions().getPersistOptions().getPersistFiles()) {
            long fileId = persistFile.getFileId();
            if (!this.mFileDataManager.needPersistence(fileId)) continue;
            try {
                this.mFileDataManager.lockBlocks(fileId, persistFile.getBlockIds());
            }
            catch (IOException e) {
                LOG.error("Failed to lock the blocks for file {}", (Object)fileId, (Object)e);
            }
            this.mPersistFileService.execute(new FilePersister(this.mFileDataManager, fileId, persistFile.getBlockIds()));
        }
    }

    public void close() {
        this.mPersistFileService.shutdown();
    }

    class FilePersister
    implements Runnable {
        private FileDataManager mFileDataManager;
        private long mFileId;
        private List<Long> mBlockIds;

        public FilePersister(FileDataManager fileDataManager, long fileId, List<Long> blockIds) {
            this.mFileDataManager = fileDataManager;
            this.mFileId = fileId;
            this.mBlockIds = blockIds;
        }

        @Override
        public void run() {
            try {
                LOG.info("persist file {} of blocks {}", (Object)this.mFileId, this.mBlockIds);
                this.mFileDataManager.persistFile(this.mFileId, this.mBlockIds);
            }
            catch (IOException e) {
                LOG.error("Failed to persist file {}", (Object)this.mFileId, (Object)e);
            }
        }
    }
}

