/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.netty;

import alluxio.Configuration;
import alluxio.network.ChannelType;
import alluxio.util.network.NettyUtils;
import alluxio.worker.DataServer;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.netty.DataServerHandler;
import alluxio.worker.netty.PipelineHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class NettyDataServer
implements DataServer {
    private final ServerBootstrap mBootstrap;
    private final ChannelFuture mChannelFuture;
    private final Configuration mConf;
    private final DataServerHandler mDataServerHandler;

    public NettyDataServer(InetSocketAddress address, BlockWorker blockWorker, Configuration configuration) {
        this.mConf = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.mDataServerHandler = new DataServerHandler((BlockWorker)Preconditions.checkNotNull((Object)blockWorker), this.mConf);
        this.mBootstrap = this.createBootstrap().childHandler((ChannelHandler)new PipelineHandler(this.mDataServerHandler));
        try {
            this.mChannelFuture = this.mBootstrap.bind((SocketAddress)address).sync();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        int quietPeriodSecs = this.mConf.getInt("alluxio.worker.network.netty.shutdown.quiet.period");
        int timeoutSecs = this.mConf.getInt("alluxio.worker.network.netty.shutdown.timeout");
        this.mChannelFuture.channel().close().awaitUninterruptibly((long)timeoutSecs, TimeUnit.SECONDS);
        this.mBootstrap.group().shutdownGracefully((long)quietPeriodSecs, (long)timeoutSecs, TimeUnit.SECONDS);
        this.mBootstrap.childGroup().shutdownGracefully((long)quietPeriodSecs, (long)timeoutSecs, TimeUnit.SECONDS);
    }

    private ServerBootstrap createBootstrap() {
        ServerBootstrap boot = this.createBootstrapOfType((ChannelType)this.mConf.getEnum("alluxio.worker.network.netty.channel", ChannelType.class));
        boot.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        boot.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        boot.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)((int)this.mConf.getBytes("alluxio.worker.network.netty.watermark.high")));
        boot.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)((int)this.mConf.getBytes("alluxio.worker.network.netty.watermark.low")));
        if (this.mConf.containsKey("alluxio.worker.network.netty.backlog")) {
            boot.option(ChannelOption.SO_BACKLOG, (Object)this.mConf.getInt("alluxio.worker.network.netty.backlog"));
        }
        if (this.mConf.containsKey("alluxio.worker.network.netty.buffer.send")) {
            boot.option(ChannelOption.SO_SNDBUF, (Object)((int)this.mConf.getBytes("alluxio.worker.network.netty.buffer.send")));
        }
        if (this.mConf.containsKey("alluxio.worker.network.netty.buffer.receive")) {
            boot.option(ChannelOption.SO_RCVBUF, (Object)((int)this.mConf.getBytes("alluxio.worker.network.netty.buffer.receive")));
        }
        return boot;
    }

    @Override
    public String getBindHost() {
        return ((InetSocketAddress)this.mChannelFuture.channel().localAddress()).getHostString();
    }

    @Override
    public int getPort() {
        return ((InetSocketAddress)this.mChannelFuture.channel().localAddress()).getPort();
    }

    @Override
    public boolean isClosed() {
        return this.mBootstrap.group().isShutdown();
    }

    private ServerBootstrap createBootstrapOfType(ChannelType type) {
        ServerBootstrap boot = new ServerBootstrap();
        int bossThreadCount = this.mConf.getInt("alluxio.worker.network.netty.boss.threads");
        int workerThreadCount = this.mConf.getInt("alluxio.worker.network.netty.worker.threads");
        EventLoopGroup bossGroup = NettyUtils.createEventLoop((ChannelType)type, (int)bossThreadCount, (String)"data-server-boss-%d", (boolean)false);
        EventLoopGroup workerGroup = NettyUtils.createEventLoop((ChannelType)type, (int)workerThreadCount, (String)"data-server-worker-%d", (boolean)false);
        Class socketChannelClass = NettyUtils.getServerChannelClass((ChannelType)type);
        boot.group(bossGroup, workerGroup).channel(socketChannelClass);
        return boot;
    }
}

