/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.netty;

import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCMessageDecoder;
import alluxio.network.protocol.RPCMessageEncoder;
import alluxio.worker.netty.DataServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PipelineHandler
extends ChannelInitializer<SocketChannel> {
    private final DataServerHandler mDataServerHandler;

    public PipelineHandler(DataServerHandler handler) {
        this.mDataServerHandler = handler;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("nioChunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("frameDecoder", (ChannelHandler)RPCMessage.createFrameDecoder());
        pipeline.addLast("RPCMessageDecoder", (ChannelHandler)new RPCMessageDecoder());
        pipeline.addLast("RPCMessageEncoder", (ChannelHandler)new RPCMessageEncoder());
        pipeline.addLast("dataServerHandler", (ChannelHandler)this.mDataServerHandler);
    }
}

