/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell;

import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.shell.command.ShellCommand;
import alluxio.util.CommonUtils;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AlluxioShell
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final HashMap<String, String[]> CMD_ALIAS = new HashMap<String, String[]>(){
        {
            this.put("chgrpr", new String[]{"chgrp", "-R"});
            this.put("chmodr", new String[]{"chmod", "-R"});
            this.put("chownr", new String[]{"chown", "-R"});
            this.put("lsr", new String[]{"ls", "-R"});
            this.put("rmr", new String[]{"rm", "-R"});
        }
    };
    private final Map<String, ShellCommand> mCommands = Maps.newHashMap();
    private final Configuration mConfiguration;
    private final FileSystem mFileSystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException {
        int ret;
        try (AlluxioShell shell = new AlluxioShell(new Configuration());){
            ret = shell.run(argv);
        }
        System.exit(ret);
    }

    public AlluxioShell(Configuration configuration) {
        this.mConfiguration = configuration;
        this.mFileSystem = FileSystem.Factory.get();
        this.loadCommands();
    }

    @Override
    public void close() throws IOException {
    }

    private void loadCommands() {
        String pkgName = ShellCommand.class.getPackage().getName();
        Reflections reflections = new Reflections(pkgName, new Scanner[0]);
        for (Class cls : reflections.getSubTypesOf(ShellCommand.class)) {
            ShellCommand cmd;
            if (Modifier.isAbstract(cls.getModifiers())) continue;
            try {
                cmd = (ShellCommand)CommonUtils.createNewClassInstance((Class)cls, (Class[])new Class[]{Configuration.class, FileSystem.class}, (Object[])new Object[]{this.mConfiguration, this.mFileSystem});
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.mCommands.put(cmd.getCommandName(), cmd);
        }
    }

    private String[] getReplacementCmd(String cmd) {
        if (CMD_ALIAS.containsKey(cmd)) {
            return CMD_ALIAS.get(cmd);
        }
        return null;
    }

    private void printUsage() {
        System.out.println("Usage: java AlluxioShell");
        TreeSet<String> sortedCmds = new TreeSet<String>(this.mCommands.keySet());
        for (String cmd : sortedCmds) {
            System.out.format("%-60s%-95s%n", "       [" + this.mCommands.get(cmd).getUsage() + "]   ", this.mCommands.get(cmd).getDescription());
        }
    }

    public int run(String ... argv) {
        if (argv.length == 0) {
            this.printUsage();
            return -1;
        }
        String cmd = argv[0];
        ShellCommand command = this.mCommands.get(cmd);
        if (command == null) {
            Object[] replacementCmd = this.getReplacementCmd(cmd);
            if (replacementCmd == null) {
                System.out.println(cmd + " is an unknown command.\n");
                this.printUsage();
                return -1;
            }
            String deprecatedMsg = "WARNING: " + cmd + " is deprecated. Please use " + StringUtils.join((Object[])replacementCmd, (String)" ") + " instead.";
            System.out.println(deprecatedMsg);
            LOG.warn(deprecatedMsg);
            String[] replacementArgv = (String[])ArrayUtils.addAll((Object[])replacementCmd, (Object[])ArrayUtils.subarray((Object[])argv, (int)1, (int)argv.length));
            return this.run(replacementArgv);
        }
        String[] args = Arrays.copyOfRange(argv, 1, argv.length);
        CommandLine cmdline = command.parseAndValidateArgs(args);
        if (cmdline == null) {
            this.printUsage();
            return -1;
        }
        try {
            command.run(cmdline);
            return 0;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            LOG.error("Error running " + StringUtils.join((Object[])argv, (String)" "), (Throwable)e);
            return -1;
        }
    }
}

