/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AlluxioShellUtils {
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");

    public static String getFilePath(String path, Configuration configuration) throws IOException {
        if ((path = AlluxioShellUtils.validatePath(path, configuration)).startsWith("alluxio://")) {
            path = path.substring("alluxio://".length());
        } else if (path.startsWith("alluxio-ft://")) {
            path = path.substring("alluxio-ft://".length());
        }
        return path.substring(path.indexOf("/"));
    }

    public static String validatePath(String path, Configuration configuration) throws IOException {
        if (path.startsWith("alluxio://") || path.startsWith("alluxio-ft://")) {
            if (!path.contains(":")) {
                throw new IOException("Invalid Path: " + path + ". Use " + "alluxio://" + "host:port/ ," + "alluxio-ft://" + "host:port/" + " , or /file");
            }
            return path;
        }
        String hostname = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (Configuration)configuration);
        int port = configuration.getInt("alluxio.master.port");
        if (configuration.getBoolean("alluxio.zookeeper.enabled")) {
            return PathUtils.concatPath((Object)("alluxio-ft://" + hostname + ":" + port), (Object[])new Object[]{path});
        }
        return PathUtils.concatPath((Object)("alluxio://" + hostname + ":" + port), (Object[])new Object[]{path});
    }

    public static List<AlluxioURI> getAlluxioURIs(FileSystem alluxioClient, AlluxioURI inputURI) throws IOException {
        if (!inputURI.getPath().contains("*")) {
            return Lists.newArrayList((Object[])new AlluxioURI[]{inputURI});
        }
        String inputPath = inputURI.getPath();
        AlluxioURI parentURI = new AlluxioURI(inputURI.getScheme(), inputURI.getAuthority(), inputPath.substring(0, inputPath.indexOf("*") + 1)).getParent();
        return AlluxioShellUtils.getAlluxioURIs(alluxioClient, inputURI, parentURI);
    }

    private static List<AlluxioURI> getAlluxioURIs(FileSystem alluxioClient, AlluxioURI inputURI, AlluxioURI parentDir) throws IOException {
        LinkedList<AlluxioURI> res = new LinkedList<AlluxioURI>();
        List statuses = null;
        try {
            statuses = alluxioClient.listStatus(parentDir);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        for (URIStatus status : statuses) {
            AlluxioURI dirURI;
            String prefix;
            AlluxioURI fileURI = new AlluxioURI(inputURI.getScheme(), inputURI.getAuthority(), status.getPath());
            if (AlluxioShellUtils.match(fileURI, inputURI)) {
                res.add(fileURI);
                continue;
            }
            if (!status.isFolder() || (prefix = inputURI.getLeadingPath((dirURI = new AlluxioURI(inputURI.getScheme(), inputURI.getAuthority(), status.getPath())).getDepth())) == null || !AlluxioShellUtils.match(dirURI, new AlluxioURI(prefix))) continue;
            res.addAll(AlluxioShellUtils.getAlluxioURIs(alluxioClient, inputURI, dirURI));
        }
        return res;
    }

    public static List<File> getFiles(String inputPath) {
        File file = new File(inputPath);
        if (!inputPath.contains("*")) {
            LinkedList<File> res = new LinkedList<File>();
            if (file.exists()) {
                res.add(file);
            }
            return res;
        }
        String prefix = inputPath.substring(0, inputPath.indexOf("*") + 1);
        String parent = new File(prefix).getParent();
        return AlluxioShellUtils.getFiles(inputPath, parent);
    }

    private static List<File> getFiles(String inputPath, String parent) {
        LinkedList<File> res = new LinkedList<File>();
        File pFile = new File(parent);
        if (!pFile.exists() || !pFile.isDirectory()) {
            return res;
        }
        if (pFile.isDirectory() && pFile.canRead()) {
            for (File file : pFile.listFiles()) {
                AlluxioURI dirURI;
                String prefix;
                if (AlluxioShellUtils.match(file.getPath(), inputPath)) {
                    res.add(file);
                    continue;
                }
                if (!file.isDirectory() || (prefix = new AlluxioURI(inputPath).getLeadingPath((dirURI = new AlluxioURI(file.getPath())).getDepth())) == null || !AlluxioShellUtils.match(dirURI, new AlluxioURI(prefix))) continue;
                res.addAll(AlluxioShellUtils.getFiles(inputPath, dirURI.getPath()));
            }
        }
        return res;
    }

    private static String escape(String str) {
        return SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }

    private static String replaceWildcards(String text) {
        return AlluxioShellUtils.escape(text).replace("\\*", ".*");
    }

    private static boolean match(AlluxioURI fileURI, AlluxioURI patternURI) {
        return AlluxioShellUtils.escape(fileURI.getPath()).matches(AlluxioShellUtils.replaceWildcards(patternURI.getPath()));
    }

    protected static boolean match(String filePath, String patternPath) {
        return AlluxioShellUtils.match(new AlluxioURI(filePath), new AlluxioURI(patternPath));
    }
}

