/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.shell.command.ShellCommand;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@ThreadSafe
public abstract class AbstractShellCommand
implements ShellCommand {
    protected Configuration mConfiguration;
    protected FileSystem mFileSystem;
    protected static final Option RECURSIVE_OPTION = Option.builder((String)"R").required(false).hasArg(false).desc("recursive").build();

    protected AbstractShellCommand(Configuration conf, FileSystem fs) {
        this.mConfiguration = conf;
        this.mFileSystem = fs;
    }

    protected boolean validateArgs(String ... args) {
        boolean valid;
        boolean bl = valid = args.length == this.getNumOfArgs();
        if (!valid) {
            System.out.println(this.getCommandName() + " takes " + this.getNumOfArgs() + " arguments, " + " not " + args.length + "\n");
        }
        return valid;
    }

    abstract int getNumOfArgs();

    protected Options getOptions() {
        return new Options();
    }

    @Override
    public CommandLine parseAndValidateArgs(String ... args) {
        CommandLine cmd;
        Options opts = this.getOptions();
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(opts, args, true);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse input args: " + e.getMessage());
            return null;
        }
        if (!this.validateArgs(cmd.getArgs())) {
            return null;
        }
        return cmd;
    }
}

