/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.SetAttributeOptions;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class ChgrpCommand
extends AbstractShellCommand {
    public ChgrpCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "chgrp";
    }

    @Override
    protected int getNumOfArgs() {
        return 2;
    }

    @Override
    protected Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION);
    }

    private void chgrp(AlluxioURI path, String group, boolean recursive) throws IOException {
        try {
            SetAttributeOptions options = SetAttributeOptions.defaults().setGroup(group).setRecursive(recursive);
            this.mFileSystem.setAttribute(path, options);
            System.out.println("Changed group of " + path + " to " + group);
        }
        catch (AlluxioException e) {
            throw new IOException("Failed to changed group of " + path + " to " + group + " : " + e.getMessage());
        }
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        String group = args[0];
        AlluxioURI path = new AlluxioURI(args[1]);
        this.chgrp(path, group, cl.hasOption("R"));
    }

    @Override
    public String getUsage() {
        return "chgrp [-R] <group> <path>";
    }

    @Override
    public String getDescription() {
        return "Changes the group of a file or directory specified by args. Specify -R to change the group recursively.";
    }
}

