/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class CountCommand
extends AbstractShellCommand {
    public CountCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "count";
    }

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        long[] values = this.countHelper(inputPath);
        String format = "%-25s%-25s%-15s%n";
        System.out.format(format, "File Count", "Folder Count", "Total Bytes");
        System.out.format(format, values[0], values[1], values[2]);
    }

    private long[] countHelper(AlluxioURI path) throws IOException {
        List statuses;
        URIStatus status;
        try {
            status = this.mFileSystem.getStatus(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        if (!status.isFolder()) {
            return new long[]{1L, 0L, status.getLength()};
        }
        long[] rtn = new long[]{0L, 1L, 0L};
        try {
            statuses = this.mFileSystem.listStatus(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        for (URIStatus uriStatus : statuses) {
            long[] toAdd = this.countHelper(new AlluxioURI(uriStatus.getPath()));
            rtn[0] = rtn[0] + toAdd[0];
            rtn[1] = rtn[1] + toAdd[1];
            rtn[2] = rtn[2] + toAdd[2];
        }
        return rtn;
    }

    @Override
    public String getUsage() {
        return "count <path>";
    }

    @Override
    public String getDescription() {
        return "Displays the number of files and directories matching the specified prefix.";
    }
}

