/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.file.FileSystem;
import alluxio.client.lineage.AlluxioLineage;
import alluxio.exception.AlluxioException;
import alluxio.job.CommandLineJob;
import alluxio.job.Job;
import alluxio.job.JobConf;
import alluxio.shell.command.AbstractShellCommand;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class CreateLineageCommand
extends AbstractShellCommand {
    public CreateLineageCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "createLineage";
    }

    @Override
    protected int getNumOfArgs() {
        return 3;
    }

    @Override
    public boolean validateArgs(String ... args) {
        boolean valid;
        boolean bl = valid = args.length >= this.getNumOfArgs();
        if (!valid) {
            System.out.println(this.getCommandName() + " takes at least" + this.getNumOfArgs() + " arguments, " + " not " + args.length + "\n");
        }
        return valid;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        long lineageId;
        String[] args = cl.getArgs();
        AlluxioLineage tl = AlluxioLineage.get();
        ArrayList inputFiles = Lists.newArrayList();
        if (!args[0].equals("noInput")) {
            for (String path : args[0].split(",")) {
                inputFiles.add(new AlluxioURI(path));
            }
        }
        ArrayList outputFiles = Lists.newArrayList();
        for (String path : args[1].split(",")) {
            outputFiles.add(new AlluxioURI(path));
        }
        String cmd = "";
        for (int i = 2; i < args.length; ++i) {
            cmd = cmd + args[i] + " ";
        }
        String outputPath = ClientContext.getConf().get("alluxio.master.lineage.recompute.log.path");
        if (outputPath == null) {
            throw new IOException("recompute output log is not configured");
        }
        CommandLineJob job = new CommandLineJob(cmd, new JobConf(outputPath));
        try {
            lineageId = tl.createLineage((List)inputFiles, (List)outputFiles, (Job)job);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        System.out.println("Lineage " + lineageId + " has been created.");
    }

    @Override
    public String getUsage() {
        return "createLineage <inputFile1,...> <outputFile1,...> [<cmd_arg1> <cmd_arg2> ...]";
    }

    @Override
    public String getDescription() {
        return "Creates a lineage.";
    }
}

