/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.lineage.AlluxioLineage;
import alluxio.client.lineage.options.DeleteLineageOptions;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class DeleteLineageCommand
extends AbstractShellCommand {
    public DeleteLineageCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "deleteLineage";
    }

    @Override
    protected int getNumOfArgs() {
        return 2;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioLineage tl = AlluxioLineage.get();
        long lineageId = Long.parseLong(args[0]);
        boolean cascade = Boolean.parseBoolean(args[1]);
        DeleteLineageOptions options = DeleteLineageOptions.defaults().setCascade(cascade);
        try {
            tl.deleteLineage(lineageId, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Lineage '" + lineageId + "' could not be deleted.");
        }
        System.out.println("Lineage " + lineageId + " has been deleted.");
    }

    @Override
    public String getUsage() {
        return "deleteLineage <lineageId> <cascade(true|false)>";
    }

    @Override
    public String getDescription() {
        return "Deletes a lineage. If cascade is specified as true, dependent lineages will also be deleted.";
    }
}

