/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class FileInfoCommand
extends WithWildCardPathCommand {
    public FileInfoCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "fileInfo";
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        URIStatus status;
        try {
            status = this.mFileSystem.getStatus(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        if (status.isFolder()) {
            throw new IOException(path + " is a directory path so does not have file blocks.");
        }
        System.out.println(status);
        System.out.println("Containing the following blocks: ");
        Iterator i$ = status.getBlockIds().iterator();
        while (i$.hasNext()) {
            long blockId = (Long)i$.next();
            System.out.println(AlluxioBlockStore.get().getInfo(blockId));
        }
    }

    @Override
    public String getUsage() {
        return "fileInfo <path>";
    }

    @Override
    public String getDescription() {
        return "Displays all block info for the specified file.";
    }
}

