/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.FreeOptions;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class FreeCommand
extends WithWildCardPathCommand {
    public FreeCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "free";
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        try {
            FreeOptions options = FreeOptions.defaults().setRecursive(true);
            this.mFileSystem.free(path, options);
            System.out.println(path + " was successfully freed from memory.");
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        return "free <file path|folder path>";
    }

    @Override
    public String getDescription() {
        return "Removes the file or directory(recursively) from Alluxio memory space.";
    }
}

