/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.WithWildCardPathCommand;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class LoadCommand
extends WithWildCardPathCommand {
    public LoadCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "load";
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        this.load(path);
    }

    private void load(AlluxioURI filePath) throws IOException {
        try {
            URIStatus status = this.mFileSystem.getStatus(filePath);
            if (status.isFolder()) {
                List statuses = this.mFileSystem.listStatus(filePath);
                for (URIStatus uriStatus : statuses) {
                    AlluxioURI newPath = new AlluxioURI(uriStatus.getPath());
                    this.load(newPath);
                }
            } else {
                if (status.getInMemoryPercentage() == 100) {
                    return;
                }
                try (Closer closer = Closer.create();){
                    OpenFileOptions options = OpenFileOptions.defaults().setReadType(ReadType.CACHE_PROMOTE);
                    FileInStream in = (FileInStream)closer.register((Closeable)this.mFileSystem.openFile(filePath, options));
                    byte[] buf = new byte[0x800000];
                    while (in.read(buf) != -1) {
                    }
                }
            }
            System.out.println(filePath + " loaded");
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        return "load <path>";
    }

    @Override
    public String getDescription() {
        return "Loads a file or directory in Alluxio space, makes it resident in memory.";
    }
}

