/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.block.AlluxioBlockStore;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.WithWildCardPathCommand;
import alluxio.wire.BlockLocation;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class LocationCommand
extends WithWildCardPathCommand {
    public LocationCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "location";
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        URIStatus status;
        try {
            status = this.mFileSystem.getStatus(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        System.out.println(path + " with file id " + status.getFileId() + " is on nodes: ");
        Iterator i$ = status.getBlockIds().iterator();
        while (i$.hasNext()) {
            long blockId = (Long)i$.next();
            for (BlockLocation location : AlluxioBlockStore.get().getInfo(blockId).getLocations()) {
                System.out.println(location.getWorkerAddress().getHost());
            }
        }
    }

    @Override
    public String getUsage() {
        return "location <path>";
    }

    @Override
    public String getDescription() {
        return "Displays the list of hosts storing the specified file.";
    }
}

