/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.CommandUtils;
import alluxio.shell.command.WithWildCardPathCommand;
import alluxio.util.FormatUtils;
import alluxio.util.SecurityUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class LsCommand
extends WithWildCardPathCommand {
    public static final String STATE_FOLDER = "";
    public static final String STATE_FILE_IN_MEMORY = "In Memory";
    public static final String STATE_FILE_NOT_IN_MEMORY = "Not In Memory";

    public static String formatLsString(boolean acl, boolean isFolder, String permission, String userName, String groupName, long size, long createTimeMs, boolean inMemory, String path) {
        String memoryState;
        if (isFolder) {
            memoryState = STATE_FOLDER;
        } else {
            String string = memoryState = inMemory ? STATE_FILE_IN_MEMORY : STATE_FILE_NOT_IN_MEMORY;
        }
        if (acl) {
            return String.format("%-15s%-15s%-15s%-10s%-25s%-15s%-5s%n", permission, userName, groupName, FormatUtils.getSizeFromBytes((long)size), CommandUtils.convertMsToDate(createTimeMs), memoryState, path);
        }
        return String.format("%-10s%-25s%-15s%-5s%n", FormatUtils.getSizeFromBytes((long)size), CommandUtils.convertMsToDate(createTimeMs), memoryState, path);
    }

    public LsCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "ls";
    }

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    protected Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION);
    }

    private void ls(AlluxioURI path, boolean recursive) throws IOException {
        List<URIStatus> statuses = this.listStatusSortedByIncreasingCreationTime(path);
        for (URIStatus status : statuses) {
            System.out.format(LsCommand.formatLsString(SecurityUtils.isSecurityEnabled((Configuration)this.mConfiguration), status.isFolder(), FormatUtils.formatPermission((short)((short)status.getPermission()), (boolean)status.isFolder()), status.getUserName(), status.getGroupName(), status.getLength(), status.getCreationTimeMs(), 100 == status.getInMemoryPercentage(), status.getPath()), new Object[0]);
            if (!recursive || !status.isFolder()) continue;
            this.ls(new AlluxioURI(path.getScheme(), path.getAuthority(), status.getPath()), true);
        }
    }

    private List<URIStatus> listStatusSortedByIncreasingCreationTime(AlluxioURI path) throws IOException {
        List statuses;
        try {
            statuses = this.mFileSystem.listStatus(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        Collections.sort(statuses, new Comparator<URIStatus>(){

            @Override
            public int compare(URIStatus status1, URIStatus status2) {
                long t2;
                long t1 = status1.getCreationTimeMs();
                if (t1 < (t2 = status2.getCreationTimeMs())) {
                    return -1;
                }
                if (t1 == t2) {
                    return 0;
                }
                return 1;
            }
        });
        return statuses;
    }

    @Override
    public void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        this.ls(path, cl.hasOption("R"));
    }

    @Override
    public String getUsage() {
        return "ls [-R] <path>";
    }

    @Override
    public String getDescription() {
        return "Displays information for all files and directories directly under the specified path. Specify -R to display files and directories recursively.";
    }
}

