/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class MountCommand
extends AbstractShellCommand {
    public MountCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "mount";
    }

    @Override
    protected int getNumOfArgs() {
        return 2;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioURI alluxioPath = new AlluxioURI(args[0]);
        AlluxioURI ufsPath = new AlluxioURI(args[1]);
        try {
            this.mFileSystem.mount(alluxioPath, ufsPath);
            System.out.println("Mounted " + ufsPath + " at " + alluxioPath);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        return "mount <alluxioPath> <ufsURI>";
    }

    @Override
    public String getDescription() {
        return "Mounts a UFS path onto an Alluxio path.";
    }
}

