/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemUtils;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.AbstractShellCommand;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class PersistCommand
extends AbstractShellCommand {
    public PersistCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "persist";
    }

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        this.persist(inputPath);
    }

    private void persist(AlluxioURI filePath) throws IOException {
        try {
            URIStatus status = this.mFileSystem.getStatus(filePath);
            if (status.isFolder()) {
                List statuses = this.mFileSystem.listStatus(filePath);
                ArrayList<String> errorMessages = new ArrayList<String>();
                for (URIStatus uriStatus : statuses) {
                    AlluxioURI newPath = new AlluxioURI(uriStatus.getPath());
                    try {
                        this.persist(newPath);
                    }
                    catch (IOException e) {
                        errorMessages.add(e.getMessage());
                    }
                }
                if (errorMessages.size() != 0) {
                    throw new IOException(Joiner.on((char)'\n').join(errorMessages));
                }
            } else if (status.isPersisted()) {
                System.out.println(filePath + " is already persisted");
            } else {
                long size = FileSystemUtils.persistFile((FileSystem)this.mFileSystem, (AlluxioURI)filePath, (URIStatus)status, (Configuration)this.mConfiguration);
                System.out.println("persisted file " + filePath + " with size " + size);
            }
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        return "persist <alluxioPath>";
    }

    @Override
    public String getDescription() {
        return "Persists a file or directory currently stored only in Alluxio to the UnderFileSystem.";
    }
}

