/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.shell.command.CommandUtils;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class PinCommand
extends WithWildCardPathCommand {
    public PinCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "pin";
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        CommandUtils.setPinned(this.mFileSystem, path, true);
        System.out.println("File '" + path + "' was successfully pinned.");
    }

    @Override
    public String getUsage() {
        return "pin <path>";
    }

    @Override
    public String getDescription() {
        return "Pins the given file or directory in memory (works recursively for directories). Pinned files are never evicted from memory, unless TTL is set.";
    }
}

