/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.lineage.LineageFileSystem;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class ReportCommand
extends WithWildCardPathCommand {
    public ReportCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "report";
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        try {
            LineageFileSystem.get().reportLostFile(path);
            System.out.println(path + " has reported been reported as lost.");
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        return "report <path>";
    }

    @Override
    public String getDescription() {
        return "Reports to the master that a file is lost.";
    }
}

