/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.DeleteOptions;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class RmCommand
extends WithWildCardPathCommand {
    public RmCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "rm";
    }

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    protected Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION);
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        try {
            boolean recursive = cl.hasOption("R");
            if (!this.mFileSystem.exists(path)) {
                throw new IOException("Path " + path + " does not exist");
            }
            if (!recursive && this.mFileSystem.getStatus(path).isFolder()) {
                throw new IOException("rm: cannot remove a directory, please try rm -R <path>");
            }
            DeleteOptions options = DeleteOptions.defaults().setRecursive(recursive);
            this.mFileSystem.delete(path, options);
            System.out.println(path + " has been removed");
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getUsage() {
        return "rm [-R] <path>";
    }

    @Override
    public String getDescription() {
        return "Removes the specified file. Specify -R to remove file or directory recursively.";
    }
}

