/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class TailCommand
extends WithWildCardPathCommand {
    public TailCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "tail";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        URIStatus status;
        try {
            status = this.mFileSystem.getStatus(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        if (status.isFolder()) throw new IOException(ExceptionMessage.PATH_MUST_BE_FILE.getMessage(new Object[]{path}));
        OpenFileOptions options = OpenFileOptions.defaults().setReadType(ReadType.NO_CACHE);
        try (FileInStream is = null;){
            is = this.mFileSystem.openFile(path, options);
            byte[] buf = new byte[1024];
            long bytesToRead = 0L;
            bytesToRead = status.getLength() > 1024L ? 1024L : status.getLength();
            is.skip(status.getLength() - bytesToRead);
            int read = is.read(buf);
            if (read == -1) return;
            System.out.write(buf, 0, read);
            return;
        }
    }

    @Override
    public String getUsage() {
        return "tail <path>";
    }

    @Override
    public String getDescription() {
        return "Prints the file's last 1KB of contents to the console.";
    }
}

