/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class TouchCommand
extends AbstractShellCommand {
    public TouchCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "touch";
    }

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        try {
            this.mFileSystem.createFile(inputPath, CreateFileOptions.defaults().setWriteType(WriteType.CACHE_THROUGH)).close();
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
        System.out.println(inputPath + " has been created");
    }

    @Override
    public String getUsage() {
        return "touch <path>";
    }

    @Override
    public String getDescription() {
        return "Creates a 0 byte file. The file will be written to the under file system.";
    }
}

