/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.shell.command.AbstractShellCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class UnmountCommand
extends AbstractShellCommand {
    public UnmountCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "unmount";
    }

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        try {
            this.mFileSystem.unmount(inputPath);
            System.out.println("Unmounted " + inputPath);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        return "unmount <alluxioPath>";
    }

    @Override
    public String getDescription() {
        return "Unmounts an Alluxio path.";
    }
}

