/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.shell.command.CommandUtils;
import alluxio.shell.command.WithWildCardPathCommand;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class UnpinCommand
extends WithWildCardPathCommand {
    public UnpinCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    @Override
    public String getCommandName() {
        return "unpin";
    }

    @Override
    void runCommand(AlluxioURI path, CommandLine cl) throws IOException {
        CommandUtils.setPinned(this.mFileSystem, path, false);
        System.out.println("File '" + path + "' was successfully unpinned.");
    }

    @Override
    public String getUsage() {
        return "unpin <path>";
    }

    @Override
    public String getDescription() {
        return "Unpins the given file or folder from memory (works recursively for a directory).";
    }
}

