/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell.command;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.file.FileSystem;
import alluxio.shell.AlluxioShellUtils;
import alluxio.shell.command.AbstractShellCommand;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public abstract class WithWildCardPathCommand
extends AbstractShellCommand {
    protected WithWildCardPathCommand(Configuration conf, FileSystem fs) {
        super(conf, fs);
    }

    abstract void runCommand(AlluxioURI var1, CommandLine var2) throws IOException;

    @Override
    protected int getNumOfArgs() {
        return 1;
    }

    @Override
    public void run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        List<AlluxioURI> paths = AlluxioShellUtils.getAlluxioURIs(this.mFileSystem, inputPath);
        if (paths.size() == 0) {
            throw new IOException(inputPath + " does not exist.");
        }
        Collections.sort(paths, WithWildCardPathCommand.createAlluxioURIComparator());
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (AlluxioURI path : paths) {
            try {
                this.runCommand(path, cl);
            }
            catch (IOException e) {
                errorMessages.add(e.getMessage());
            }
        }
        if (errorMessages.size() != 0) {
            throw new IOException(Joiner.on((char)'\n').join(errorMessages));
        }
    }

    private static Comparator<AlluxioURI> createAlluxioURIComparator() {
        return new Comparator<AlluxioURI>(){

            @Override
            public int compare(AlluxioURI tUri1, AlluxioURI tUri2) {
                return tUri1.getPath().compareTo(tUri2.getPath());
            }
        };
    }
}

